/*
 * Decompiled with CFR 0.152.
 */
package com.google.openrtb.snippet;

import com.google.common.collect.ImmutableList;
import com.google.openrtb.OpenRtb;
import com.google.openrtb.snippet.OpenRtbMacros;
import com.google.openrtb.snippet.SnippetMacroType;
import com.google.openrtb.snippet.SnippetProcessor;
import com.google.openrtb.snippet.SnippetProcessorContext;
import com.google.openrtb.snippet.UndefinedMacroException;
import java.util.List;
import javax.inject.Singleton;

@Singleton
public class OpenRtbSnippetProcessor
extends SnippetProcessor {
    public static final OpenRtbSnippetProcessor ORTB_NULL = new OpenRtbSnippetProcessor(false){

        @Override
        public String process(SnippetProcessorContext ctx, String snippet) {
            return SnippetProcessor.NULL.process(ctx, snippet);
        }
    };
    private final boolean extendedFields;

    public OpenRtbSnippetProcessor(boolean extendedFields) {
        this.extendedFields = extendedFields;
    }

    public OpenRtbSnippetProcessor() {
        this(false);
    }

    @Override
    protected List<SnippetMacroType> registerMacros() {
        return ImmutableList.copyOf((Object[])OpenRtbMacros.values());
    }

    @Override
    protected boolean processMacroAt(SnippetProcessorContext ctx, SnippetMacroType macroDef) {
        if (macroDef instanceof OpenRtbMacros) {
            switch ((OpenRtbMacros)macroDef) {
                case AUCTION_AD_ID: {
                    if (ctx.getBid().hasAdid()) {
                        ctx.builder().append(ctx.getBid().getAdid());
                    }
                    return true;
                }
                case AUCTION_BID_ID: {
                    if (ctx.response().hasBidid()) {
                        ctx.builder().append(ctx.response().getBidid());
                    }
                    return true;
                }
                case AUCTION_CURRENCY: {
                    if (ctx.request().getCurCount() == 1) {
                        ctx.builder().append(ctx.request().getCur(0));
                    }
                    return true;
                }
                case AUCTION_ID: {
                    ctx.builder().append(ctx.request().getId());
                    return true;
                }
                case AUCTION_IMP_ID: {
                    ctx.builder().append(this.findImp(ctx, macroDef).getId());
                    return true;
                }
                case AUCTION_SEAT_ID: {
                    OpenRtb.BidResponse.SeatBidOrBuilder seatBid = this.findSeat(ctx, macroDef);
                    if (seatBid.hasSeat()) {
                        ctx.builder().append(seatBid.getSeat());
                    }
                    return true;
                }
                case AUCTION_PRICE: 
                case AUCTION_MBR: 
                case AUCTION_LOSS: {
                    ctx.builder().append(((OpenRtbMacros)macroDef).key());
                    return true;
                }
            }
        }
        return false;
    }

    public void process(SnippetProcessorContext bidCtx) {
        for (OpenRtb.BidResponse.SeatBid.Builder seat : bidCtx.response().getSeatbidBuilderList()) {
            for (OpenRtb.BidResponse.SeatBid.Bid.Builder bid : seat.getBidBuilderList()) {
                bidCtx.setBid(bid);
                this.processFields(bidCtx);
            }
        }
    }

    protected void processFields(SnippetProcessorContext bidCtx) {
        OpenRtb.BidResponse.SeatBid.Bid.Builder bid = bidCtx.getBid();
        if (this.extendedFields) {
            if (bid.hasAdid()) {
                bid.setAdid(this.process(bidCtx, bid.getAdid()));
            }
            bid.setId(this.process(bidCtx, bid.getId()));
        }
        if (bid.hasAdm()) {
            bid.setAdm(this.process(bidCtx, bid.getAdm()));
        }
        if (this.extendedFields) {
            if (bid.hasBurl()) {
                bid.setBurl(this.process(bidCtx, bid.getBurl()));
            }
            if (bid.hasCid()) {
                bid.setCid(this.process(bidCtx, bid.getCid()));
            }
            if (bid.hasCrid()) {
                bid.setCrid(this.process(bidCtx, bid.getCrid()));
            }
            if (bid.hasDealid()) {
                bid.setDealid(this.process(bidCtx, bid.getDealid()));
            }
            bid.setImpid(this.process(bidCtx, bid.getImpid()));
            if (bid.hasIurl()) {
                bid.setIurl(this.process(bidCtx, bid.getIurl()));
            }
            if (bid.hasLurl()) {
                bid.setIurl(this.process(bidCtx, bid.getLurl()));
            }
            if (bid.hasNurl()) {
                bid.setNurl(this.process(bidCtx, bid.getNurl()));
            }
        }
    }

    private OpenRtb.BidResponse.SeatBidOrBuilder findSeat(SnippetProcessorContext ctx, SnippetMacroType macro) {
        for (OpenRtb.BidResponse.SeatBidOrBuilder seatBidOrBuilder : ctx.response().getSeatbidOrBuilderList()) {
            for (OpenRtb.BidResponse.SeatBid.BidOrBuilder bidOrBuilder : seatBidOrBuilder.getBidOrBuilderList()) {
                if (bidOrBuilder != ctx.getBid()) continue;
                return seatBidOrBuilder;
            }
        }
        throw new UndefinedMacroException(macro, "Bid doesn't belong to this request");
    }

    protected OpenRtb.BidRequest.ImpOrBuilder findImp(SnippetProcessorContext ctx, SnippetMacroType macro) {
        for (OpenRtb.BidRequest.ImpOrBuilder impOrBuilder : ctx.request().getImpOrBuilderList()) {
            if (!impOrBuilder.getId().equals(ctx.getBid().getImpid())) continue;
            return impOrBuilder;
        }
        throw new UndefinedMacroException(macro, "Bid's impression id: " + ctx.getBid().getImpid() + " doesn't match request");
    }
}

