/*
 * Decompiled with CFR 0.152.
 */
package com.google.openrtb.snippet;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;
import com.google.openrtb.snippet.SnippetMacroType;
import com.google.openrtb.snippet.SnippetProcessorContext;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SnippetProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SnippetProcessor.class);
    private static final Escaper ESCAPER = new PercentEscaper("-_.*", true);
    public static final SnippetProcessor NULL = new SnippetProcessor(){

        @Override
        public String process(SnippetProcessorContext ctx, String snippet) {
            Preconditions.checkNotNull((Object)ctx);
            return (String)Preconditions.checkNotNull((Object)snippet);
        }

        @Override
        protected boolean processMacroAt(SnippetProcessorContext ctx, SnippetMacroType macroDef) {
            return false;
        }
    };
    private final ImmutableList<SnippetMacroType> scanMacros;

    public SnippetProcessor() {
        List<SnippetMacroType> registered = this.registerMacros();
        Object[] macros = registered.toArray(new SnippetMacroType[registered.size()]);
        Arrays.sort(macros, new Comparator<SnippetMacroType>(){

            @Override
            public int compare(SnippetMacroType o1, SnippetMacroType o2) {
                return o1.key().compareTo(o2.key());
            }
        });
        this.scanMacros = ImmutableList.copyOf((Object[])macros);
    }

    protected List<SnippetMacroType> registerMacros() {
        return ImmutableList.of();
    }

    public static Escaper getEscaper() {
        return ESCAPER;
    }

    public String process(SnippetProcessorContext ctx, String snippet) {
        Preconditions.checkNotNull((Object)ctx);
        StringBuilder sb = ctx.builder();
        sb.setLength(0);
        String currSnippet = snippet;
        boolean processedMacros = false;
        int snippetPos = 0;
        int macroPos = currSnippet.indexOf("${");
        while (macroPos != -1) {
            sb.append(currSnippet.substring(snippetPos, macroPos));
            int macroEnd = this.processMacroAt(ctx, currSnippet, macroPos);
            if (macroEnd == -1) {
                sb.append("${");
                snippetPos = macroPos + 2;
            } else {
                snippetPos = macroEnd;
                processedMacros = true;
            }
            macroPos = currSnippet.indexOf("${", snippetPos);
        }
        if (processedMacros) {
            sb.append(currSnippet, snippetPos, currSnippet.length());
            currSnippet = sb.toString();
        }
        sb.setLength(0);
        String ret = SnippetProcessor.urlEncode(ctx, currSnippet);
        sb.setLength(0);
        return ret;
    }

    private int processMacroAt(SnippetProcessorContext ctx, String snippet, int macroStart) {
        SnippetMacroType macroDef = this.match(snippet, macroStart);
        if (macroDef == null) {
            return -1;
        }
        this.processMacroAt(ctx, macroDef);
        StringBuilder sb = ctx.builder();
        int macroPos = sb.indexOf("${");
        if (macroPos != -1) {
            String recReplaced;
            String recSnippet = sb.substring(macroPos);
            if (!macroDef.key().equals(recSnippet) && (recReplaced = this.process(ctx.rec(), recSnippet)) != recSnippet) {
                sb.setLength(macroPos);
                sb.append(recReplaced);
            }
        }
        return macroStart + macroDef.key().length();
    }

    private SnippetMacroType match(String snippet, int macroStart) {
        for (SnippetMacroType macroDef : this.scanMacros) {
            if (!macroDef.key().regionMatches(0, snippet, macroStart, macroDef.key().length())) continue;
            return macroDef;
        }
        return null;
    }

    protected abstract boolean processMacroAt(SnippetProcessorContext var1, SnippetMacroType var2);

    protected static String urlEncode(SnippetProcessorContext ctx, String snippet) {
        int snippetPos = snippet.indexOf("%{");
        if (snippetPos == -1) {
            return snippet;
        }
        StringBuilder sb = ctx.builder();
        int encodeLevel = 0;
        int encodeStart = 0;
        int lastPos = snippet.length() - 1;
        while (snippetPos <= lastPos) {
            char c = snippet.charAt(snippetPos);
            if (c == '%' && snippetPos < lastPos && snippet.charAt(snippetPos + 1) == '{') {
                sb.append(SnippetProcessor.flushEncoding(snippet, encodeStart, snippetPos, encodeLevel++));
                encodeStart = snippetPos += 2;
                continue;
            }
            if (c == '}' && snippetPos < lastPos && snippet.charAt(snippetPos + 1) == '%' && encodeLevel > 0) {
                sb.append(SnippetProcessor.flushEncoding(snippet, encodeStart, snippetPos, encodeLevel--));
                encodeStart = snippetPos += 2;
                continue;
            }
            ++snippetPos;
        }
        if (encodeLevel != 0) {
            logger.warn("Unbalanced '%{': level={}, pos={}", (Object)encodeLevel, (Object)snippetPos);
        }
        return sb.append(SnippetProcessor.flushEncoding(snippet, encodeStart, snippet.length(), 0)).toString();
    }

    private static String flushEncoding(String snippet, int encodeStart, int encodeEnd, int encodeLevel) {
        String substr = snippet.substring(encodeStart, encodeEnd);
        for (int i = 0; i < encodeLevel; ++i) {
            substr = SnippetProcessor.getEscaper().escape(substr);
        }
        return substr;
    }

    public final String toString() {
        return this.toStringHelper().toString();
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues();
    }
}

