/*
 * Decompiled with CFR 0.152.
 */
package com.google.openrtb.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.openrtb.OpenRtb;
import com.google.openrtb.util.ProtoUtils;
import com.google.openrtb.util.ResponseBidsIterator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class OpenRtbUtils {
    public static final String SEAT_ANY = "*";
    public static final Predicate<OpenRtb.BidRequest.Imp> IMP_NONE = imp -> false;
    public static final Predicate<OpenRtb.BidRequest.Imp> IMP_ALL = imp -> true;
    private static final ImmutableMap<Object, String> CAT_TO_JSON;
    private static final ImmutableMap<String, OpenRtb.ContentCategory> NAME_TO_CAT;

    @Nullable
    public static OpenRtb.ContentCategory categoryFromName(@Nullable String catName) {
        return (OpenRtb.ContentCategory)((Object)NAME_TO_CAT.get((Object)catName));
    }

    @Nullable
    public static String categoryToJsonName(@Nullable String catName) {
        return (String)CAT_TO_JSON.get((Object)catName);
    }

    @Nullable
    public static String categoryToJsonName(@Nullable OpenRtb.ContentCategory cat) {
        return (String)CAT_TO_JSON.get((Object)cat);
    }

    public static OpenRtb.BidResponse.SeatBid.Builder seatBid(OpenRtb.BidResponse.Builder response, String seat) {
        Preconditions.checkNotNull((Object)seat);
        for (OpenRtb.BidResponse.SeatBid.Builder seatbid : response.getSeatbidBuilderList()) {
            if (!seatbid.hasSeat() || !seat.equals(seatbid.getSeat())) continue;
            return seatbid;
        }
        return response.addSeatbidBuilder().setSeat(seat);
    }

    public static OpenRtb.BidResponse.SeatBid.Builder seatBid(OpenRtb.BidResponse.Builder response) {
        for (OpenRtb.BidResponse.SeatBid.Builder seatbid : response.getSeatbidBuilderList()) {
            if (seatbid.hasSeat()) continue;
            return seatbid;
        }
        return response.addSeatbidBuilder();
    }

    public static Iterable<OpenRtb.BidResponse.SeatBid.Bid.Builder> bids(OpenRtb.BidResponse.Builder response) {
        return new ResponseBidsIterator(response, SEAT_ANY, null);
    }

    public static List<OpenRtb.BidResponse.SeatBid.Bid.Builder> bids(OpenRtb.BidResponse.Builder response, @Nullable String seatFilter) {
        for (OpenRtb.BidResponse.SeatBid.Builder seatbid : response.getSeatbidBuilderList()) {
            if (!OpenRtbUtils.filterSeat(seatbid, seatFilter)) continue;
            return seatbid.getBidBuilderList();
        }
        return ImmutableList.of();
    }

    @Nullable
    public static OpenRtb.BidResponse.SeatBid.Bid.Builder bidWithId(OpenRtb.BidResponse.Builder response, String id) {
        Preconditions.checkNotNull((Object)id);
        for (OpenRtb.BidResponse.SeatBid.Builder seatbid : response.getSeatbidBuilderList()) {
            for (OpenRtb.BidResponse.SeatBid.Bid.Builder bid : seatbid.getBidBuilderList()) {
                if (!id.equals(bid.getId())) continue;
                return bid;
            }
        }
        return null;
    }

    @Nullable
    public static OpenRtb.BidResponse.SeatBid.Bid.Builder bidWithId(OpenRtb.BidResponse.Builder response, @Nullable String seatFilter, String id) {
        Preconditions.checkNotNull((Object)id);
        for (OpenRtb.BidResponse.SeatBid.Builder seatbid : response.getSeatbidBuilderList()) {
            if (!OpenRtbUtils.filterSeat(seatbid, seatFilter)) continue;
            for (OpenRtb.BidResponse.SeatBid.Bid.Builder bid : seatbid.getBidBuilderList()) {
                if (!id.equals(bid.getId())) continue;
                return bid;
            }
            return null;
        }
        return null;
    }

    public static Stream<OpenRtb.BidResponse.SeatBid.Bid.Builder> bidStreamWith(OpenRtb.BidResponse.Builder response, @Nullable String seatFilter, @Nullable Predicate<OpenRtb.BidResponse.SeatBid.Bid.Builder> bidFilter) {
        return StreamSupport.stream(new ResponseBidsIterator(response, seatFilter, bidFilter).spliterator(), false);
    }

    public static Iterable<OpenRtb.BidResponse.SeatBid.Bid.Builder> bidsWith(OpenRtb.BidResponse.Builder response, @Nullable String seatFilter, @Nullable Predicate<OpenRtb.BidResponse.SeatBid.Bid.Builder> bidFilter) {
        return new ResponseBidsIterator(response, seatFilter, bidFilter);
    }

    public static boolean updateBids(OpenRtb.BidResponse.Builder response, Function<OpenRtb.BidResponse.SeatBid.Bid.Builder, Boolean> updater) {
        Preconditions.checkNotNull(updater);
        boolean updated = false;
        for (OpenRtb.BidResponse.SeatBid.Builder seatbid : response.getSeatbidBuilderList()) {
            updated |= ProtoUtils.update(seatbid.getBidBuilderList(), updater);
        }
        return updated;
    }

    public static boolean updateBids(OpenRtb.BidResponse.Builder response, @Nullable String seatFilter, Function<OpenRtb.BidResponse.SeatBid.Bid.Builder, Boolean> updater) {
        Preconditions.checkNotNull(updater);
        for (OpenRtb.BidResponse.SeatBid.Builder seatbid : response.getSeatbidBuilderList()) {
            if (!OpenRtbUtils.filterSeat(seatbid, seatFilter)) continue;
            return ProtoUtils.update(seatbid.getBidBuilderList(), updater);
        }
        return false;
    }

    public static boolean removeBids(OpenRtb.BidResponse.Builder response, Predicate<OpenRtb.BidResponse.SeatBid.Bid.Builder> filter) {
        Preconditions.checkNotNull(filter);
        boolean updated = false;
        for (OpenRtb.BidResponse.SeatBid.Builder seatbid : response.getSeatbidBuilderList()) {
            updated |= OpenRtbUtils.removeBids(seatbid, filter);
        }
        return updated;
    }

    private static boolean removeBids(OpenRtb.BidResponse.SeatBid.Builder seatbid, Predicate<OpenRtb.BidResponse.SeatBid.Bid.Builder> filter) {
        List<OpenRtb.BidResponse.SeatBid.Bid.Builder> oldBids = seatbid.getBidBuilderList();
        List<OpenRtb.BidResponse.SeatBid.Bid.Builder> newBids = ProtoUtils.filter(oldBids, filter);
        if (newBids == oldBids) {
            return false;
        }
        seatbid.clearBid();
        for (OpenRtb.BidResponse.SeatBid.Bid.Builder bid : newBids) {
            seatbid.addBid(bid);
        }
        return true;
    }

    public static boolean removeBids(OpenRtb.BidResponse.Builder response, @Nullable String seatFilter, Predicate<OpenRtb.BidResponse.SeatBid.Bid.Builder> bidFilter) {
        Preconditions.checkNotNull(bidFilter);
        boolean updated = false;
        for (OpenRtb.BidResponse.SeatBid.Builder seatbid : response.getSeatbidBuilderList()) {
            if (!OpenRtbUtils.filterSeat(seatbid, seatFilter)) continue;
            updated |= OpenRtbUtils.removeBids(seatbid, bidFilter);
        }
        return updated;
    }

    @Nullable
    public static OpenRtb.BidRequest.Imp impWithId(OpenRtb.BidRequest request, String id) {
        Preconditions.checkNotNull((Object)id);
        for (OpenRtb.BidRequest.Imp imp : request.getImpList()) {
            if (!imp.getId().equals(id)) continue;
            return imp;
        }
        return null;
    }

    @Nullable
    public static OpenRtb.BidRequest.Imp bannerImpWithId(OpenRtb.BidRequest request, @Nullable String impId, String bannerId) {
        Preconditions.checkNotNull((Object)bannerId);
        for (OpenRtb.BidRequest.Imp imp : request.getImpList()) {
            if (impId != null && !imp.getId().equals(impId) || !imp.hasBanner() || !imp.getBanner().getId().equals(bannerId)) continue;
            return imp;
        }
        return null;
    }

    public static Iterable<OpenRtb.BidRequest.Imp> impsWith(OpenRtb.BidRequest request, Predicate<OpenRtb.BidRequest.Imp> impFilter) {
        int i;
        Preconditions.checkNotNull(impFilter);
        ImmutableList imps = request.getImpList();
        if (imps.isEmpty() || impFilter == IMP_ALL) {
            return imps;
        }
        if (impFilter == IMP_NONE) {
            return ImmutableList.of();
        }
        boolean included = impFilter.test(imps.get(0));
        int size = imps.size();
        for (i = 1; i < size && impFilter.test(imps.get(i)) == included; ++i) {
        }
        if (i == size) {
            return included ? imps : ImmutableList.of();
        }
        int headingSize = i;
        return new FluentIterable<OpenRtb.BidRequest.Imp>((List)imps, headingSize, included, impFilter){
            final /* synthetic */ List val$imps;
            final /* synthetic */ int val$headingSize;
            final /* synthetic */ boolean val$included;
            final /* synthetic */ Predicate val$impFilter;
            {
                this.val$imps = list;
                this.val$headingSize = n;
                this.val$included = bl;
                this.val$impFilter = predicate;
            }

            public Iterator<OpenRtb.BidRequest.Imp> iterator() {
                final Iterator unfiltered = this.val$imps.iterator();
                return new AbstractIterator<OpenRtb.BidRequest.Imp>(){
                    private int heading = 0;

                    protected OpenRtb.BidRequest.Imp computeNext() {
                        while (unfiltered.hasNext()) {
                            OpenRtb.BidRequest.Imp imp = (OpenRtb.BidRequest.Imp)unfiltered.next();
                            if (!(this.heading++ < val$headingSize ? val$included : val$impFilter.test(imp))) continue;
                            return imp;
                        }
                        return (OpenRtb.BidRequest.Imp)this.endOfData();
                    }
                };
            }
        };
    }

    public static Stream<OpenRtb.BidRequest.Imp> impStreamWith(OpenRtb.BidRequest request, Predicate<OpenRtb.BidRequest.Imp> impFilter) {
        return StreamSupport.stream(OpenRtbUtils.impsWith(request, impFilter).spliterator(), false);
    }

    public static Predicate<OpenRtb.BidRequest.Imp> addFilters(Predicate<OpenRtb.BidRequest.Imp> baseFilter, boolean banner, boolean video, boolean nativ) {
        int orCount = (banner ? 1 : 0) + (video ? 1 : 0) + (nativ ? 1 : 0);
        if (baseFilter == IMP_NONE || orCount == 0) {
            return baseFilter;
        }
        Predicate<OpenRtb.BidRequest.Imp> typeFilter = null;
        if (banner) {
            typeFilter = OpenRtb.BidRequest.Imp::hasBanner;
        }
        if (video) {
            Predicate<OpenRtb.BidRequest.Imp> predicate = typeFilter = typeFilter == null ? OpenRtb.BidRequest.Imp::hasVideo : typeFilter.or(OpenRtb.BidRequest.Imp::hasVideo);
        }
        if (nativ) {
            typeFilter = typeFilter == null ? OpenRtb.BidRequest.Imp::hasNative : typeFilter.or(OpenRtb.BidRequest.Imp::hasNative);
        }
        return baseFilter == IMP_ALL ? typeFilter : baseFilter.and(typeFilter);
    }

    public static boolean filterSeat(OpenRtb.BidResponse.SeatBidOrBuilder seatbid, @Nullable String seatFilter) {
        return seatFilter == null ? !seatbid.hasSeat() : seatFilter == SEAT_ANY || seatFilter.equals(seatbid.getSeat());
    }

    static {
        ImmutableMap.Builder catToJson = ImmutableMap.builder();
        ImmutableMap.Builder nameToCat = ImmutableMap.builder();
        for (OpenRtb.ContentCategory cat : OpenRtb.ContentCategory.values()) {
            String json = cat.name().replace('_', '-');
            catToJson.put((Object)cat.name(), (Object)json);
            catToJson.put((Object)cat, (Object)json);
            nameToCat.put((Object)cat.name(), (Object)cat);
            if (json.equals(cat.name())) continue;
            catToJson.put((Object)json, (Object)json);
            nameToCat.put((Object)json, (Object)cat);
        }
        CAT_TO_JSON = catToJson.build();
        NAME_TO_CAT = nameToCat.build();
    }
}

