/*
 * Decompiled with CFR 0.152.
 */
package com.google.openrtb.util;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.openrtb.OpenRtb;
import com.google.openrtb.util.OpenRtbUtils;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OpenRtbValidator {
    private static final Logger logger = LoggerFactory.getLogger(OpenRtbValidator.class);
    private final Counter unmatchedImp = new Counter();
    private final Counter invalidCreatAttr = new Counter();
    private final Counter invalidAdv = new Counter();

    @Inject
    public OpenRtbValidator(MetricRegistry metricRegistry) {
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"unmatched-imp"}), (Metric)this.unmatchedImp);
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"invalid-creative-attr"}), (Metric)this.invalidCreatAttr);
        metricRegistry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"invalid-advertiser"}), (Metric)this.invalidAdv);
    }

    public boolean validate(OpenRtb.BidRequest request, OpenRtb.BidResponse.Builder response) {
        return !OpenRtbUtils.removeBids(response, bid -> this.validate(request, (OpenRtb.BidResponse.SeatBid.Bid.Builder)bid));
    }

    public boolean validate(OpenRtb.BidRequest request, OpenRtb.BidResponse.SeatBid.Bid.Builder bid) {
        OpenRtb.BidRequest.Imp imp = OpenRtbUtils.impWithId(request, bid.getImpid());
        if (imp == null) {
            this.unmatchedImp.inc();
            if (logger.isDebugEnabled()) {
                logger.debug("{} rejected, unmatched impid: {}", (Object)OpenRtbValidator.logId(bid), (Object)bid.getImpid());
            }
            return false;
        }
        boolean goodBid = true;
        List badAdvs = OpenRtbValidator.check(request.getBadvList(), bid.getAdomainList());
        if (!badAdvs.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} rejected, blocked adomain values: {}", (Object)OpenRtbValidator.logId(bid), badAdvs);
            }
            this.invalidAdv.inc();
            goodBid = false;
        }
        if (imp.hasBanner()) {
            goodBid &= this.validateCreats(bid, OpenRtbValidator.check(imp.getBanner().getBattrList(), bid.getAttrList()));
        }
        if (imp.hasVideo()) {
            goodBid &= this.validateCreats(bid, OpenRtbValidator.check(imp.getVideo().getBattrList(), bid.getAttrList()));
            goodBid &= this.validateCompanions(bid, imp.getVideo().getCompanionadList());
        }
        if (imp.hasAudio()) {
            goodBid &= this.validateCreats(bid, OpenRtbValidator.check(imp.getAudio().getBattrList(), bid.getAttrList()));
            goodBid &= this.validateCompanions(bid, imp.getAudio().getCompanionadList());
        }
        return goodBid;
    }

    protected boolean validateCreats(OpenRtb.BidResponse.SeatBid.Bid.Builder bid, List<OpenRtb.CreativeAttribute> badCreats) {
        if (badCreats.isEmpty()) {
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} rejected, blocked attr values: {}", (Object)OpenRtbValidator.logId(bid), badCreats);
        }
        this.invalidCreatAttr.inc();
        return false;
    }

    protected boolean validateCompanions(OpenRtb.BidResponse.SeatBid.Bid.Builder bid, List<OpenRtb.BidRequest.Imp.Banner> companions) {
        for (OpenRtb.BidRequest.Imp.Banner companion : companions) {
            List<OpenRtb.CreativeAttribute> badCompCreats = OpenRtbValidator.check(companion.getBattrList(), bid.getAttrList());
            if (badCompCreats.isEmpty()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("{} rejected, blocked attr values: {}", (Object)OpenRtbValidator.logId(bid), badCompCreats);
            }
            this.invalidCreatAttr.inc();
            return false;
        }
        return true;
    }

    protected static String logId(OpenRtb.BidResponse.SeatBid.Bid.Builder bid) {
        if (bid.hasId()) {
            return "Bid " + bid.getId();
        }
        StringBuilder sb = new StringBuilder().append("Bid (impid ").append(bid.getImpid());
        if (bid.hasAdid()) {
            sb.append(", adid ").append(bid.getAdid());
        }
        return sb.append(')').toString();
    }

    protected static <T> List<T> check(List<T> reqAttrs, List<T> respAttrs) {
        ArrayList<T> bad = null;
        if (!respAttrs.isEmpty()) {
            ImmutableSet reqIndex = reqAttrs.size() > 4 ? ImmutableSet.copyOf(reqAttrs) : reqAttrs;
            for (T attribute : respAttrs) {
                if (!reqIndex.contains(attribute)) continue;
                if (bad == null) {
                    bad = new ArrayList<T>();
                }
                bad.add(attribute);
            }
        }
        return bad == null ? ImmutableList.of() : bad;
    }
}

