/*
 * Decompiled with CFR 0.152.
 */
package com.google.openrtb.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageLiteOrBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class ProtoUtils {
    public static final Predicate<Descriptors.FieldDescriptor> NOT_EXTENSION = fd -> !fd.isExtension();

    private ProtoUtils() {
    }

    public static <I extends MessageLiteOrBuilder, O extends MessageLite> O built(@Nullable I msg) {
        return (O)(msg instanceof MessageLite.Builder ? ((MessageLite.Builder)msg).build() : (MessageLite)msg);
    }

    public static <I extends MessageLiteOrBuilder, O extends MessageLite.Builder> O builder(@Nullable I msg) {
        return (O)(msg instanceof MessageLite ? ((MessageLite)msg).toBuilder() : (MessageLite.Builder)msg);
    }

    public static <B extends MessageLite.Builder> boolean update(Iterable<B> objs, Function<B, Boolean> updater) {
        Preconditions.checkNotNull(updater);
        boolean updated = false;
        for (MessageLite.Builder obj : objs) {
            updated |= updater.apply(obj).booleanValue();
        }
        return updated;
    }

    public static <M extends MessageLiteOrBuilder> List<M> filter(List<M> objs, Predicate<M> filter) {
        Preconditions.checkNotNull(filter);
        for (int i = 0; i < objs.size(); ++i) {
            if (filter.test((MessageLiteOrBuilder)objs.get(i))) continue;
            return ProtoUtils.filterFrom(objs, filter, i);
        }
        return objs;
    }

    private static <M extends MessageLiteOrBuilder> List<M> filterFrom(List<M> objs, Predicate<M> filter, int firstDiscarded) {
        int i;
        ArrayList<MessageLiteOrBuilder> filtered;
        if (firstDiscarded == 0) {
            filtered = null;
        } else {
            filtered = new ArrayList<MessageLiteOrBuilder>(objs.size() - 1);
            for (i = 0; i < firstDiscarded; ++i) {
                filtered.add((MessageLiteOrBuilder)objs.get(i));
            }
        }
        for (i = firstDiscarded + 1; i < objs.size(); ++i) {
            MessageLiteOrBuilder obj = (MessageLiteOrBuilder)objs.get(i);
            if (!filter.test(obj)) continue;
            if (filtered == null) {
                filtered = new ArrayList(objs.size() - i);
            }
            filtered.add(obj);
        }
        return filtered == null ? ImmutableList.of() : filtered;
    }

    @Nullable
    public static <M extends Message> M filter(M msg, boolean clearEmpty, Predicate<Descriptors.FieldDescriptor> filter) {
        Preconditions.checkNotNull(filter);
        int i = 0;
        for (Map.Entry entry : msg.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor fd = (Descriptors.FieldDescriptor)entry.getKey();
            if (!filter.test(fd)) {
                return ProtoUtils.filterFrom(msg, clearEmpty, filter, i, true);
            }
            if (fd.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                return ProtoUtils.filterFrom(msg, clearEmpty, filter, i, false);
            }
            ++i;
        }
        return msg;
    }

    @Nullable
    private static <M extends Message> M filterFrom(M msg, boolean clearEmpty, Predicate<Descriptors.FieldDescriptor> filter, int first, boolean discard) {
        Message ret;
        Message.Builder builder = first == 0 ? null : msg.newBuilderForType();
        Iterator iter = msg.getAllFields().entrySet().iterator();
        for (int i = 0; i < first; ++i) {
            ProtoUtils.filterValue(clearEmpty, filter, builder, iter.next());
        }
        if (discard) {
            iter.next();
        }
        boolean updated = discard;
        while (iter.hasNext()) {
            Map.Entry<Descriptors.FieldDescriptor, Object> entry = iter.next();
            if (filter.test((Descriptors.FieldDescriptor)entry.getKey())) {
                if (builder == null) {
                    builder = msg.newBuilderForType();
                }
                updated |= ProtoUtils.filterValue(clearEmpty, filter, builder, entry);
                continue;
            }
            updated = true;
        }
        if (builder == null) {
            if (clearEmpty) {
                return null;
            }
            ret = msg.getDefaultInstanceForType();
            return (M)ret;
        }
        if (updated) {
            ret = builder.build();
            return (M)ret;
        }
        return msg;
    }

    protected static boolean filterValue(boolean clearEmpty, Predicate<Descriptors.FieldDescriptor> filter, Message.Builder builder, Map.Entry<Descriptors.FieldDescriptor, Object> entry) {
        Descriptors.FieldDescriptor fd = entry.getKey();
        Object value = entry.getValue();
        boolean updated = false;
        if (fd.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            if (fd.isRepeated()) {
                for (Object obj : (Iterable)value) {
                    Message child = ProtoUtils.filter((Message)obj, clearEmpty, filter);
                    if (child == null) {
                        updated = true;
                        continue;
                    }
                    updated = child != obj;
                    builder.addRepeatedField(fd, (Object)child);
                }
            } else {
                Message child = ProtoUtils.filter((Message)value, clearEmpty, filter);
                if (child == null) {
                    updated = true;
                } else {
                    updated = child != value;
                    builder.setField(fd, (Object)child);
                }
            }
        } else {
            builder.setField(fd, value);
        }
        return updated;
    }
}

