/*
 * Decompiled with CFR 0.152.
 */
package com.google.openrtb.util;

import com.google.openrtb.OpenRtb;
import com.google.openrtb.util.OpenRtbUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import javax.annotation.Nullable;

class ResponseBidsIterator
implements Iterator<OpenRtb.BidResponse.SeatBid.Bid.Builder>,
Iterable<OpenRtb.BidResponse.SeatBid.Bid.Builder> {
    @Nullable
    private final String seatFilter;
    private final Predicate<OpenRtb.BidResponse.SeatBid.Bid.Builder> bidFilter;
    private final Iterator<OpenRtb.BidResponse.SeatBid.Builder> seatbidIter;
    private Iterator<OpenRtb.BidResponse.SeatBid.Bid.Builder> bidIter = Collections.emptyIterator();
    private OpenRtb.BidResponse.SeatBid.Bid.Builder nextBid;

    public ResponseBidsIterator(OpenRtb.BidResponse.Builder bidResponse, @Nullable String seatFilter, @Nullable Predicate<OpenRtb.BidResponse.SeatBid.Bid.Builder> bidFilter) {
        this.seatbidIter = bidResponse.getSeatbidBuilderList().iterator();
        this.seatFilter = seatFilter;
        this.bidFilter = bidFilter;
    }

    @Override
    public boolean hasNext() {
        this.scanIters();
        return this.nextBid != null;
    }

    @Override
    public OpenRtb.BidResponse.SeatBid.Bid.Builder next() {
        this.scanIters();
        if (this.nextBid == null) {
            throw new NoSuchElementException();
        }
        OpenRtb.BidResponse.SeatBid.Bid.Builder ret = this.nextBid;
        this.nextBid = null;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<OpenRtb.BidResponse.SeatBid.Bid.Builder> iterator() {
        return this;
    }

    private void scanIters() {
        while (!this.scanBidIter() && this.seatbidIter.hasNext()) {
            OpenRtb.BidResponse.SeatBid.Builder seatBid = this.seatbidIter.next();
            if (!OpenRtbUtils.filterSeat(seatBid, this.seatFilter)) continue;
            this.bidIter = seatBid.getBidBuilderList().iterator();
        }
    }

    private boolean scanBidIter() {
        while (this.nextBid == null) {
            if (!this.bidIter.hasNext()) {
                return false;
            }
            this.nextBid = this.bidIter.next();
            if (this.bidFilter == null || this.bidFilter.test(this.nextBid)) continue;
            this.nextBid = null;
        }
        return true;
    }
}

