/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.gradle;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.tasks.WorkResult;

interface CopyActionFacade {
    public WorkResult copy(Action<? super CopySpec> var1);

    public static abstract class FileSystemOperationsBased
    implements CopyActionFacade {
        @Inject
        public abstract FileSystemOperations getFileSystemOperations();

        @Override
        public WorkResult copy(Action<? super CopySpec> action) {
            return this.getFileSystemOperations().copy(action);
        }
    }

    public static class ProjectBased
    implements CopyActionFacade {
        private final Project project;

        public ProjectBased(Project project) {
            this.project = project;
        }

        @Override
        public WorkResult copy(Action<? super CopySpec> action) {
            return this.project.copy(action);
        }
    }
}

