/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.gradle;

import com.google.common.base.Preconditions;
import com.google.protobuf.gradle.ArchiveActionFacade;
import com.google.protobuf.gradle.CopyActionFacade;
import com.google.protobuf.gradle.Utils;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

public abstract class ProtobufExtract
extends DefaultTask
implements GroovyObject {
    private File destDir;
    private Boolean isTest;
    private final ConfigurableFileCollection inputFiles;
    private final CopyActionFacade copyActionFacade;
    private final ArchiveActionFacade archiveActionFacade;
    private final FileCollection filteredProtos;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ Class $class$com$google$protobuf$gradle$CopyActionFacade;

    @Generated
    public ProtobufExtract() {
        MetaClass metaClass;
        FileCollection fileCollection;
        ArchiveActionFacade archiveActionFacade;
        CopyActionFacade copyActionFacade;
        ConfigurableFileCollection configurableFileCollection;
        Object var1_1 = null;
        this.isTest = (Boolean)ScriptBytecodeAdapter.castToType(var1_1, Boolean.class);
        this.inputFiles = configurableFileCollection = this.getObjectFactory().fileCollection();
        this.copyActionFacade = copyActionFacade = this.instantiateCopyActionFacade();
        this.archiveActionFacade = archiveActionFacade = this.instantiateArchiveActionFacade();
        this.filteredProtos = fileCollection = this.instantiateFilteredProtos();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void setIsTest(boolean isTest) {
        boolean bl = isTest;
        this.isTest = bl;
    }

    @Input
    public boolean getIsTest() {
        Preconditions.checkNotNull((Object)this.isTest);
        return DefaultTypeTransformation.booleanUnbox((Object)this.isTest);
    }

    @org.gradle.api.tasks.Internal
    public ConfigurableFileCollection getInputFiles() {
        return this.inputFiles;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getFilteredProtosFromInputs() {
        public final class _getFilteredProtosFromInputs_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getFilteredProtosFromInputs_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(PatternFilterable pattern) {
                return pattern.include(new String[]{"**/*.proto"});
            }

            public Object call(PatternFilterable pattern) {
                return this.doCall(pattern);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getFilteredProtosFromInputs_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return this.filteredProtos.getAsFileTree().matching((Closure)new _getFilteredProtosFromInputs_closure1((Object)this, (Object)this));
    }

    @org.gradle.api.tasks.Internal
    public CopyActionFacade getCopyActionFacade() {
        return this.copyActionFacade;
    }

    @org.gradle.api.tasks.Internal
    public ArchiveActionFacade getArchiveActionFacade() {
        return this.archiveActionFacade;
    }

    @Inject
    public abstract ObjectFactory getObjectFactory();

    @TaskAction
    public void extract() {
        this.destDir.mkdir();
        Reference allProtoFiles = new Reference((Object)this.filteredProtos);
        public final class _extract_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference allProtoFiles;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extract_closure2(Object _outerInstance, Object _thisObject, Reference allProtoFiles) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.allProtoFiles = reference = allProtoFiles;
            }

            public Object doCall(Object spec) {
                boolean bl = false;
                ((CopySpec)spec).setIncludeEmptyDirs(bl);
                ((CopySpec)spec).from(new Object[]{this.allProtoFiles.get()});
                ((CopySpec)spec).include(new String[]{"**/*.proto"});
                ((CopySpec)spec).into(InvokerHelper.invokeMethodSafe((Object)((Object)((ProtobufExtract)((Object)this.getThisObject()))), (String)"getDestDir", (Object)new Object[0]));
                DuplicatesStrategy duplicatesStrategy = DuplicatesStrategy.INCLUDE;
                ((CopySpec)spec).setDuplicatesStrategy(duplicatesStrategy);
                return duplicatesStrategy;
            }

            @Generated
            public FileCollection getAllProtoFiles() {
                return (FileCollection)ScriptBytecodeAdapter.castToType((Object)this.allProtoFiles.get(), FileCollection.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extract_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        this.copyActionFacade.copy((Action<? super CopySpec>)((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _extract_closure2((Object)this, (Object)this, allProtoFiles)), Action.class)));
    }

    protected void setDestDir(File destDir) {
        File file;
        Preconditions.checkState((this.destDir == null ? 1 : 0) != 0, (Object)"destDir already set");
        this.destDir = file = destDir;
        this.getOutputs().dir((Object)destDir);
    }

    @OutputDirectory
    protected File getDestDir() {
        return this.destDir;
    }

    private CopyActionFacade instantiateCopyActionFacade() {
        if (Utils.compareGradleVersion(this.getProject(), "6.0") > 0) {
            return (CopyActionFacade)ScriptBytecodeAdapter.castToType((Object)this.getObjectFactory().newInstance(CopyActionFacade.FileSystemOperationsBased.class, new Object[0]), (Class)ProtobufExtract.$get$$class$com$google$protobuf$gradle$CopyActionFacade());
        }
        return new CopyActionFacade.ProjectBased(this.getProject());
    }

    private ArchiveActionFacade instantiateArchiveActionFacade() {
        if (Utils.compareGradleVersion(this.getProject(), "6.0") > 0) {
            return (ArchiveActionFacade)ScriptBytecodeAdapter.castToType((Object)this.getObjectFactory().newInstance(ArchiveActionFacade.ServiceBased.class, new Object[0]), ArchiveActionFacade.class);
        }
        return new ArchiveActionFacade.ProjectBased(this.getProject());
    }

    private FileCollection instantiateFilteredProtos() {
        Reference warningLogged = new Reference((Object)false);
        Reference archiveFacade = new Reference((Object)this.archiveActionFacade);
        Reference logger = new Reference((Object)this.getLogger());
        public final class _instantiateFilteredProtos_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference warningLogged;
            private /* synthetic */ Reference logger;
            private /* synthetic */ Reference archiveFacade;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _instantiateFilteredProtos_closure3(Object _outerInstance, Object _thisObject, Reference warningLogged, Reference logger, Reference archiveFacade) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.warningLogged = reference3 = warningLogged;
                this.logger = reference2 = logger;
                this.archiveFacade = reference = archiveFacade;
            }

            public Object doCall(Object files) {
                Reference protoFilter = new Reference((Object)new PatternSet().include(new String[]{"**/*.proto"}));
                Reference protoInputs = new Reference((Object)((Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class)));
                FileSystemLocation location = null;
                Iterator iterator = ((Set)files).iterator();
                while (iterator.hasNext()) {
                    location = (FileSystemLocation)ScriptBytecodeAdapter.castToType(iterator.next(), FileSystemLocation.class);
                    File file = location.getAsFile();
                    if (file.isDirectory()) {
                        ((Set)protoInputs.get()).add(file);
                        continue;
                    }
                    if (file.getPath().endsWith(".proto")) {
                        if (!DefaultTypeTransformation.booleanUnbox((Object)this.warningLogged.get())) {
                            boolean bl = true;
                            this.warningLogged.set((Object)bl);
                            ((Logger)this.logger.get()).warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file.getPath()}, new String[]{"proto file '", "' directly specified in configuration. "}).plus("It's likely you specified files('path/to/foo.proto') or ").plus("fileTree('path/to/directory') in protobuf or compile configuration. ").plus("This makes you vulnerable to ").plus("https://github.com/google/protobuf-gradle-plugin/issues/248. ").plus("Please use files('path/to/directory') instead.")));
                        }
                        ((Set)protoInputs.get()).add(file);
                        continue;
                    }
                    if (file.getPath().endsWith(".jar") || file.getPath().endsWith(".zip")) {
                        ((Set)protoInputs.get()).add(((ArchiveActionFacade)this.archiveFacade.get()).zipTree(file.getPath()).matching((PatternFilterable)((PatternSet)protoFilter.get())));
                        continue;
                    }
                    if (file.getPath().endsWith(".aar")) {
                        public final class _closure4
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure4(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(File it) {
                                return it.getPath().endsWith(".jar");
                            }

                            public Object call(File it) {
                                return this.doCall(it);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure4.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        FileCollection zipTree = ((ArchiveActionFacade)this.archiveFacade.get()).zipTree(file.getPath()).filter((Closure)new _closure4((Object)this, this.getThisObject()));
                        public final class _closure5
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference protoInputs;
                            private /* synthetic */ Reference archiveFacade;
                            private /* synthetic */ Reference protoFilter;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure5(Object _outerInstance, Object _thisObject, Reference protoInputs, Reference archiveFacade, Reference protoFilter) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                this.protoInputs = reference3 = protoInputs;
                                this.archiveFacade = reference2 = archiveFacade;
                                this.protoFilter = reference = protoFilter;
                            }

                            public Object doCall(Object entry) {
                                return ((Set)this.protoInputs.get()).add(((ArchiveActionFacade)this.archiveFacade.get()).zipTree(entry).matching((PatternFilterable)ScriptBytecodeAdapter.castToType((Object)this.protoFilter.get(), PatternFilterable.class)));
                            }

                            @Generated
                            public Set getProtoInputs() {
                                return (Set)ScriptBytecodeAdapter.castToType((Object)this.protoInputs.get(), Set.class);
                            }

                            @Generated
                            public ArchiveActionFacade getArchiveFacade() {
                                return (ArchiveActionFacade)ScriptBytecodeAdapter.castToType((Object)this.archiveFacade.get(), ArchiveActionFacade.class);
                            }

                            @Generated
                            public PatternSet getProtoFilter() {
                                return (PatternSet)ScriptBytecodeAdapter.castToType((Object)this.protoFilter.get(), PatternSet.class);
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure5.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        DefaultGroovyMethods.each((Iterable)zipTree, (Closure)new _closure5((Object)this, this.getThisObject(), protoInputs, this.archiveFacade, protoFilter));
                        continue;
                    }
                    if (file.getPath().endsWith(".tar") || file.getPath().endsWith(".tar.gz") || file.getPath().endsWith(".tar.bz2") || file.getPath().endsWith(".tgz")) {
                        ((Set)protoInputs.get()).add(((ArchiveActionFacade)this.archiveFacade.get()).tarTree(file.getPath()).matching((PatternFilterable)((PatternSet)protoFilter.get())));
                        continue;
                    }
                    ((Logger)this.logger.get()).debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{file.getPath()}, new String[]{"Skipping unsupported file type (", "); handles only jar, tar, tar.gz, tar.bz2 & tgz"})));
                }
                return (Set)protoInputs.get();
            }

            @Generated
            public Boolean getWarningLogged() {
                return (Boolean)ScriptBytecodeAdapter.castToType((Object)this.warningLogged.get(), Boolean.class);
            }

            @Generated
            public Logger getLogger() {
                return (Logger)ScriptBytecodeAdapter.castToType((Object)this.logger.get(), Logger.class);
            }

            @Generated
            public ArchiveActionFacade getArchiveFacade() {
                return (ArchiveActionFacade)ScriptBytecodeAdapter.castToType((Object)this.archiveFacade.get(), ArchiveActionFacade.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _instantiateFilteredProtos_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return this.getObjectFactory().fileCollection().from(new Object[]{this.inputFiles.getElements().map((Transformer)ScriptBytecodeAdapter.castToType((Object)((Object)new _instantiateFilteredProtos_closure3((Object)this, (Object)this, warningLogged, logger, archiveFacade)), Transformer.class))});
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ProtobufExtract.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    private static /* synthetic */ Class $get$$class$com$google$protobuf$gradle$CopyActionFacade() {
        Class clazz = $class$com$google$protobuf$gradle$CopyActionFacade;
        if (clazz == null) {
            clazz = $class$com$google$protobuf$gradle$CopyActionFacade = ProtobufExtract.class$("com.google.protobuf.gradle.CopyActionFacade");
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

