/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.Base64Variant;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.FormatFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParseException;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.ObjectCodec;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.io.IOContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileConstants;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileParserBase;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.dataformat.smile.SmileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class SmileParser
extends SmileParserBase {
    private static final boolean JDK11_OR_LATER;
    protected ObjectCodec _objectCodec;
    protected InputStream _inputStream;
    protected byte[] _inputBuffer;
    protected boolean _bufferRecyclable;
    protected int _typeAsInt;
    protected boolean _tokenIncomplete = false;

    public SmileParser(IOContext iOContext, int n2, int n3, ObjectCodec objectCodec, ByteQuadsCanonicalizer byteQuadsCanonicalizer, InputStream inputStream, byte[] byArray, int n4, int n5, boolean bl2) {
        super(iOContext, n2, n3, byteQuadsCanonicalizer);
        this._objectCodec = objectCodec;
        this._inputStream = inputStream;
        this._inputBuffer = byArray;
        this._inputPtr = n4;
        this._inputEnd = n5;
        this._bufferRecyclable = bl2;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    protected boolean handleSignature(boolean bl2, boolean bl3) throws IOException {
        byte by2;
        if (bl2) {
            ++this._inputPtr;
        }
        if ((by2 = this._nextByteGuaranteed()) != 41) {
            if (bl3) {
                this._reportError(String.format("Malformed content: signature not valid, starts with 0x3A but followed by 0x%02X, not 0x29", by2 & 0xFF));
            }
            return false;
        }
        by2 = this._nextByteGuaranteed();
        if (by2 != 10) {
            if (bl3) {
                this._reportError(String.format("Malformed content: signature not valid, starts with 0x3A, 0x29, but followed by 0x%02X, not 0xA", by2 & 0xFF));
            }
            return false;
        }
        byte by3 = this._nextByteGuaranteed();
        int n2 = by3 >> 4 & 0xF;
        if (n2 != 0) {
            this._reportError(String.format("Header version number bits (0x%X) indicate unrecognized version; only 0x0 accepted by parser", n2));
        }
        if ((by3 & 1) == 0) {
            this._seenNames = null;
            this._seenNameCount = -1;
        }
        if ((by3 & 2) != 0) {
            this._seenStringValues = NO_STRINGS;
            this._seenStringValueCount = 0;
        }
        this._mayContainRawBinary = (by3 & 4) != 0;
        return true;
    }

    private final byte _nextByteGuaranteed() throws IOException {
        int n2 = this._inputPtr;
        if (n2 < this._inputEnd) {
            byte by2 = this._inputBuffer[n2];
            this._inputPtr = n2 + 1;
            return by2;
        }
        this._loadMoreGuaranteed();
        return this._inputBuffer[this._inputPtr++];
    }

    protected final void _loadMoreGuaranteed() throws IOException {
        if (!this._loadMore()) {
            this._reportInvalidEOF();
        }
    }

    protected final boolean _loadMore() throws IOException {
        if (this._inputStream != null) {
            int n2 = this._inputStream.read(this._inputBuffer, 0, this._inputBuffer.length);
            this._currInputProcessed += (long)this._inputEnd;
            this._inputPtr = 0;
            if (n2 > 0) {
                this._inputEnd = n2;
                return true;
            }
            this._inputEnd = 0;
            this._closeInput();
            if (n2 == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    protected final void _loadToHaveAtLeast(int n2) throws IOException {
        if (this._inputStream == null) {
            throw this._constructError(String.format("Needed to read %d bytes, reached end-of-input", n2));
        }
        int n3 = this._tryToLoadToHaveAtLeast(n2);
        if (n3 > 0) {
            throw this._constructError(String.format("Needed to read %d bytes, only got %d before end-of-input", n2, n2 - n3));
        }
    }

    protected final int _tryToLoadToHaveAtLeast(int n2) throws IOException {
        if (this._inputStream == null) {
            return n2;
        }
        int n3 = this._inputEnd - this._inputPtr;
        this._currInputProcessed += (long)this._inputPtr;
        if (n3 > 0 && this._inputPtr > 0) {
            System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, n3);
            this._inputEnd = n3;
        } else {
            this._inputEnd = 0;
        }
        this._inputPtr = 0;
        while (this._inputEnd < n2) {
            int n4 = this._inputBuffer.length - this._inputEnd;
            int n5 = this._inputStream.read(this._inputBuffer, this._inputEnd, n4);
            if (n5 < 1) {
                this._closeInput();
                if (n5 == 0) {
                    throw new IOException("InputStream.read() returned 0 characters when trying to read " + n3 + " bytes");
                }
                return n2 - this._inputEnd;
            }
            this._inputEnd += n5;
        }
        return 0;
    }

    @Override
    protected void _closeInput() throws IOException {
        if (this._inputStream != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                this._inputStream.close();
            }
            this._inputStream = null;
        }
    }

    @Override
    public boolean hasTextCharacters() {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.hasTextAsCharacters();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    @Override
    protected void _releaseBuffers2() {
        byte[] byArray;
        if (this._bufferRecyclable && (byArray = this._inputBuffer) != null) {
            this._inputBuffer = null;
            this._ioContext.releaseReadIOBuffer(byArray);
        }
    }

    @Override
    public JsonToken nextToken() throws IOException {
        int n2;
        this._numTypesValid = 0;
        if (this._tokenIncomplete) {
            this._skipIncomplete();
        }
        this._tokenOffsetForTotal = this._inputPtr;
        this._binaryValue = null;
        if (this._currToken != JsonToken.FIELD_NAME && this._streamReadContext.inObject()) {
            this._currToken = this._handleFieldName();
            return this._currToken;
        }
        if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
            return this._eofAsNextToken();
        }
        this._typeAsInt = n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (n2 >> 5) {
            case 0: {
                if (n2 == 0) break;
                return this._handleSharedString(n2 - 1);
            }
            case 1: {
                int n3 = n2 & 0x1F;
                if (n3 < 4) {
                    switch (n3) {
                        case 0: {
                            this._textBuffer.resetWithEmpty();
                            this._currToken = JsonToken.VALUE_STRING;
                            return this._currToken;
                        }
                        case 1: {
                            this._currToken = JsonToken.VALUE_NULL;
                            return this._currToken;
                        }
                        case 2: {
                            this._currToken = JsonToken.VALUE_FALSE;
                            return this._currToken;
                        }
                    }
                    this._currToken = JsonToken.VALUE_TRUE;
                    return this._currToken;
                }
                if (n3 == 4) {
                    this._finishInt();
                    this._currToken = JsonToken.VALUE_NUMBER_INT;
                    return this._currToken;
                }
                if (n3 <= 6) {
                    this._tokenIncomplete = true;
                    this._currToken = JsonToken.VALUE_NUMBER_INT;
                    return this._currToken;
                }
                if (n3 < 11 && n3 != 7) {
                    this._tokenIncomplete = true;
                    this._currToken = JsonToken.VALUE_NUMBER_FLOAT;
                    return this._currToken;
                }
                if (n3 != 26) break;
                if (this.handleSignature(false, false)) {
                    if (this._currToken == null) {
                        return this._nextAfterHeader();
                    }
                    this._currToken = null;
                    return null;
                }
                this._reportError("Unrecognized token byte 0x3A (malformed segment header?");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this._seenStringValueCount >= 0) {
                    return this._addSeenStringValue();
                }
                this._tokenIncomplete = true;
                this._currToken = JsonToken.VALUE_STRING;
                return this._currToken;
            }
            case 6: {
                this._numberInt = SmileUtil.zigzagDecode(n2 & 0x1F);
                this._numTypesValid = 1;
                this._numberType = JsonParser.NumberType.INT;
                this._currToken = JsonToken.VALUE_NUMBER_INT;
                return this._currToken;
            }
            case 7: {
                switch (n2 & 0x1F) {
                    case 0: 
                    case 4: {
                        this._tokenIncomplete = true;
                        this._currToken = JsonToken.VALUE_STRING;
                        return this._currToken;
                    }
                    case 8: {
                        this._tokenIncomplete = true;
                        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                        return this._currToken;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        if (this._inputPtr >= this._inputEnd) {
                            this._loadMoreGuaranteed();
                        }
                        return this._handleSharedString(((n2 & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF));
                    }
                    case 24: {
                        this.createChildArrayContext(-1, -1);
                        this._currToken = JsonToken.START_ARRAY;
                        return this._currToken;
                    }
                    case 25: {
                        if (!this._streamReadContext.inArray()) {
                            this._reportMismatchedEndMarker(93, '}');
                        }
                        this._streamReadContext = this._streamReadContext.getParent();
                        this._currToken = JsonToken.END_ARRAY;
                        return this._currToken;
                    }
                    case 26: {
                        this.createChildObjectContext(-1, -1);
                        this._currToken = JsonToken.START_OBJECT;
                        return this._currToken;
                    }
                    case 27: {
                        this._reportError("Invalid type marker byte 0xFB in value mode (would be END_OBJECT in key mode)");
                    }
                    case 29: {
                        this._tokenIncomplete = true;
                        this._currToken = JsonToken.VALUE_EMBEDDED_OBJECT;
                        return this._currToken;
                    }
                    case 31: {
                        this._currToken = null;
                        return null;
                    }
                }
            }
        }
        return this._reportUnknownValueTypeToken(n2);
    }

    private JsonToken _reportUnknownValueTypeToken(int n2) throws IOException {
        throw this._constructReadException("Invalid type marker byte 0x%s for expected value token", Integer.toHexString(n2 & 0xFF));
    }

    private JsonToken _nextAfterHeader() throws IOException {
        if ((this._inputPtr < this._inputEnd || this._loadMore()) && this._inputBuffer[this._inputPtr] == 58) {
            this._currToken = null;
            return null;
        }
        return this.nextToken();
    }

    private final JsonToken _handleSharedString(int n2) throws IOException {
        if (n2 >= this._seenStringValueCount) {
            this._reportInvalidSharedStringValue(n2);
        }
        this._textBuffer.resetWithString(this._seenStringValues[n2]);
        this._currToken = JsonToken.VALUE_STRING;
        return this._currToken;
    }

    private final JsonToken _addSeenStringValue() throws IOException {
        this._finishToken();
        String string = this._textBuffer.contentsAsString();
        if (this._seenStringValueCount < this._seenStringValues.length) {
            this._seenStringValues[this._seenStringValueCount++] = string;
        } else {
            this._expandSeenStringValues(string);
        }
        this._currToken = JsonToken.VALUE_STRING;
        return this._currToken;
    }

    private final void _expandSeenStringValues(String string) {
        String[] stringArray;
        String[] stringArray2 = this._seenStringValues;
        int n2 = stringArray2.length;
        if (n2 == 0) {
            stringArray = new String[64];
        } else if (n2 == 1024) {
            stringArray = stringArray2;
            this._seenStringValueCount = 0;
        } else {
            int n3 = n2 == 64 ? 256 : 1024;
            stringArray = Arrays.copyOf(stringArray2, n3);
        }
        this._seenStringValues = stringArray;
        this._seenStringValues[this._seenStringValueCount++] = string;
    }

    @Override
    public String nextFieldName() throws IOException {
        if (this._currToken != JsonToken.FIELD_NAME && this._streamReadContext.inObject()) {
            int n2;
            this._numTypesValid = 0;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            this._tokenOffsetForTotal = this._inputPtr;
            this._binaryValue = null;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            this._typeAsInt = n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
            switch (n2 >> 6) {
                case 0: {
                    switch (n2) {
                        case 32: {
                            this._streamReadContext.setCurrentName("");
                            this._currToken = JsonToken.FIELD_NAME;
                            return "";
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: {
                            int n3;
                            if (this._inputPtr >= this._inputEnd) {
                                this._loadMoreGuaranteed();
                            }
                            if ((n3 = ((n2 & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF)) >= this._seenNameCount) {
                                this._reportInvalidSharedName(n3);
                            }
                            String string = this._seenNames[n3];
                            this._streamReadContext.setCurrentName(string);
                            this._currToken = JsonToken.FIELD_NAME;
                            return string;
                        }
                        case 52: {
                            this._currToken = JsonToken.FIELD_NAME;
                            return this._handleLongFieldName();
                        }
                    }
                    break;
                }
                case 1: {
                    int n4 = n2 & 0x3F;
                    if (n4 >= this._seenNameCount) {
                        this._reportInvalidSharedName(n4);
                    }
                    String string = this._seenNames[n4];
                    this._streamReadContext.setCurrentName(string);
                    this._currToken = JsonToken.FIELD_NAME;
                    return string;
                }
                case 2: {
                    int n5 = 1 + (n2 & 0x3F);
                    String string = this._findOrDecodeShortAsciiName(n5);
                    if (this._seenNames != null) {
                        if (this._seenNameCount >= this._seenNames.length) {
                            this._seenNames = this._expandSeenNames(this._seenNames);
                        }
                        this._seenNames[this._seenNameCount++] = string;
                    }
                    this._streamReadContext.setCurrentName(string);
                    this._currToken = JsonToken.FIELD_NAME;
                    return string;
                }
                case 3: {
                    if ((n2 &= 0x3F) > 55) {
                        if (n2 != 59) break;
                        this._streamReadContext = this._streamReadContext.getParent();
                        this._currToken = JsonToken.END_OBJECT;
                        return null;
                    }
                    int n6 = n2 + 2;
                    String string = this._findOrDecodeShortUnicodeName(n6);
                    if (this._seenNames != null) {
                        if (this._seenNameCount >= this._seenNames.length) {
                            this._seenNames = this._expandSeenNames(this._seenNames);
                        }
                        this._seenNames[this._seenNameCount++] = string;
                    }
                    this._streamReadContext.setCurrentName(string);
                    this._currToken = JsonToken.FIELD_NAME;
                    return string;
                }
            }
            return this._reportUnknownNameToken(this._typeAsInt);
        }
        return this.nextToken() == JsonToken.FIELD_NAME ? this.currentName() : null;
    }

    private String _reportUnknownNameToken(int n2) throws IOException {
        throw this._constructReadException("Invalid type marker byte 0x%s for expected field name (or END_OBJECT marker)", Integer.toHexString(n2 & 0xFF));
    }

    @Override
    public String nextTextValue() throws IOException {
        if (!this._streamReadContext.inObject() || this._currToken == JsonToken.FIELD_NAME) {
            int n2;
            int n3;
            if (this._tokenIncomplete) {
                this._skipIncomplete();
            }
            if ((n3 = this._inputPtr) >= this._inputEnd) {
                if (!this._loadMore()) {
                    this._eofAsNextToken();
                    return null;
                }
                n3 = this._inputPtr;
            }
            this._tokenOffsetForTotal = n3;
            this._typeAsInt = n2 = this._inputBuffer[n3++] & 0xFF;
            this._binaryValue = null;
            switch (n2 >> 5) {
                case 0: {
                    if (n2 != 0) {
                        if (--n2 >= this._seenStringValueCount) {
                            this._reportInvalidSharedStringValue(n2);
                        }
                        this._inputPtr = n3;
                        String string = this._seenStringValues[n2];
                        this._textBuffer.resetWithString(string);
                        this._currToken = JsonToken.VALUE_STRING;
                        return string;
                    }
                    this._reportError("Invalid token byte 0x00");
                }
                case 1: {
                    int n4 = n2 & 0x1F;
                    if (n4 != 0) break;
                    this._inputPtr = n3;
                    this._textBuffer.resetWithEmpty();
                    this._currToken = JsonToken.VALUE_STRING;
                    return "";
                }
                case 2: 
                case 3: {
                    this._currToken = JsonToken.VALUE_STRING;
                    this._inputPtr = n3;
                    String string = this._decodeShortAsciiValue(1 + (n2 & 0x3F));
                    if (this._seenStringValueCount >= 0) {
                        if (this._seenStringValueCount < this._seenStringValues.length) {
                            this._seenStringValues[this._seenStringValueCount++] = string;
                        } else {
                            this._expandSeenStringValues(string);
                        }
                    }
                    return string;
                }
                case 4: 
                case 5: {
                    this._currToken = JsonToken.VALUE_STRING;
                    this._inputPtr = n3;
                    String string = this._decodeShortUnicodeValue(2 + (n2 & 0x3F));
                    if (this._seenStringValueCount >= 0) {
                        if (this._seenStringValueCount < this._seenStringValues.length) {
                            this._seenStringValues[this._seenStringValueCount++] = string;
                        } else {
                            this._expandSeenStringValues(string);
                        }
                    }
                    return string;
                }
                case 6: {
                    break;
                }
            }
        }
        return this.nextToken() == JsonToken.VALUE_STRING ? this.getText() : null;
    }

    @Override
    public int nextIntValue(int n2) throws IOException {
        if (this.nextToken() == JsonToken.VALUE_NUMBER_INT) {
            return this.getIntValue();
        }
        return n2;
    }

    @Override
    public String getText() throws IOException {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            int n2 = this._typeAsInt;
            int n3 = n2 >> 5;
            if (n3 == 2 || n3 == 3) {
                return this._decodeShortAsciiValue(1 + (n2 & 0x3F));
            }
            if (n3 == 4 || n3 == 5) {
                return this._decodeShortUnicodeValue(2 + (n2 & 0x3F));
            }
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return null;
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            return this._streamReadContext.getCurrentName();
        }
        if (jsonToken.isNumeric()) {
            return this.getNumberValue().toString();
        }
        return this._currToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._textBuffer.getTextBuffer();
            }
            if (this._currToken == JsonToken.FIELD_NAME) {
                if (!this._nameCopied) {
                    String string = this._streamReadContext.getCurrentName();
                    int n2 = string.length();
                    if (this._nameCopyBuffer == null) {
                        this._nameCopyBuffer = this._ioContext.allocNameCopyBuffer(n2);
                    } else if (this._nameCopyBuffer.length < n2) {
                        this._nameCopyBuffer = new char[n2];
                    }
                    string.getChars(0, n2, this._nameCopyBuffer, 0);
                    this._nameCopied = true;
                }
                return this._nameCopyBuffer;
            }
            if (this._currToken.isNumeric()) {
                return this.getNumberValue().toString().toCharArray();
            }
            return this._currToken.asCharArray();
        }
        return null;
    }

    @Override
    public int getTextLength() throws IOException {
        if (this._currToken != null) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._textBuffer.size();
            }
            if (this._currToken == JsonToken.FIELD_NAME) {
                return this._streamReadContext.getCurrentName().length();
            }
            if (this._currToken == JsonToken.VALUE_NUMBER_INT || this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
                return this.getNumberValue().toString().length();
            }
            return this._currToken.asCharArray().length;
        }
        return 0;
    }

    @Override
    public int getTextOffset() throws IOException {
        return 0;
    }

    @Override
    public String getValueAsString() throws IOException {
        if (this._tokenIncomplete) {
            this._tokenIncomplete = false;
            int n2 = this._typeAsInt;
            int n3 = n2 >> 5;
            if (n3 == 2 || n3 == 3) {
                return this._decodeShortAsciiValue(1 + (n2 & 0x3F));
            }
            if (n3 == 4 || n3 == 5) {
                return this._decodeShortUnicodeValue(2 + (n2 & 0x3F));
            }
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_STRING) {
            return this._textBuffer.contentsAsString();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return null;
        }
        return this.getText();
    }

    @Override
    public String getValueAsString(String string) throws IOException {
        if (!(this._currToken == JsonToken.VALUE_STRING || this._currToken != null && this._currToken != JsonToken.VALUE_NULL && this._currToken.isScalarValue())) {
            return string;
        }
        return this.getText();
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            if (this._tokenIncomplete) {
                this._finishToken();
            }
        } else {
            if (this._currToken == JsonToken.VALUE_STRING) {
                return this._getBinaryFromString(base64Variant);
            }
            throw this._constructReadException("Current token (%s) not VALUE_EMBEDDED_OBJECT or VALUE_STRING, can not access as binary", (Object)this.currentToken());
        }
        return this._binaryValue;
    }

    @Override
    public Object getEmbeddedObject() throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._currToken == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return this._binaryValue;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException {
        if (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT) {
            if (this._currToken == JsonToken.VALUE_STRING) {
                byte[] byArray = this._getBinaryFromString(base64Variant);
                int n2 = byArray.length;
                outputStream.write(byArray, 0, n2);
                return n2;
            }
            throw this._constructReadException("Current token (%s) not VALUE_EMBEDDED_OBJECT or VALUE_STRING, can not access as binary", (Object)this.currentToken());
        }
        if (!this._tokenIncomplete) {
            if (this._binaryValue == null) {
                return 0;
            }
            int n3 = this._binaryValue.length;
            outputStream.write(this._binaryValue, 0, n3);
            return n3;
        }
        if (this._typeAsInt == 253) {
            int n4;
            int n5;
            for (int i2 = n4 = this._readUnsignedVInt(); i2 > 0; i2 -= n5) {
                int n6 = this._inputEnd - this._inputPtr;
                if (this._inputPtr >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                    n6 = this._inputEnd - this._inputPtr;
                }
                n5 = Math.min(n6, i2);
                outputStream.write(this._inputBuffer, this._inputPtr, n5);
                this._inputPtr += n5;
            }
            this._tokenIncomplete = false;
            return n4;
        }
        if (this._typeAsInt != 232) {
            this._throwInternal();
        }
        int n7 = this._readUnsignedVInt();
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            this._readBinaryEncoded(outputStream, n7, byArray);
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
        this._tokenIncomplete = false;
        return n7;
    }

    private void _readBinaryEncoded(OutputStream outputStream, int n2, byte[] byArray) throws IOException {
        int n3;
        int n4;
        int n5 = 0;
        int n6 = byArray.length - 7;
        while (n2 > 7) {
            if (this._inputEnd - this._inputPtr < 8) {
                this._loadToHaveAtLeast(8);
            }
            n4 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
            n3 = this._inputBuffer[this._inputPtr++];
            int n7 = ((n3 & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
            byArray[n5++] = (byte)((n4 += n3 >> 3) >> 24);
            byArray[n5++] = (byte)(n4 >> 16);
            byArray[n5++] = (byte)(n4 >> 8);
            byArray[n5++] = (byte)n4;
            byArray[n5++] = (byte)(n7 >> 16);
            byArray[n5++] = (byte)(n7 >> 8);
            byArray[n5++] = (byte)n7;
            n2 -= 7;
            if (n5 <= n6) continue;
            outputStream.write(byArray, 0, n5);
            n5 = 0;
        }
        if (n2 > 0) {
            if (this._inputEnd - this._inputPtr < n2 + 1) {
                this._loadToHaveAtLeast(n2 + 1);
            }
            n4 = this._inputBuffer[this._inputPtr++];
            for (n3 = 1; n3 < n2; ++n3) {
                n4 = (n4 << 7) + this._inputBuffer[this._inputPtr++];
                byArray[n5++] = (byte)(n4 >> 7 - n3);
            }
            byArray[n5++] = (byte)((n4 <<= n2) + this._inputBuffer[this._inputPtr++]);
        }
        if (n5 > 0) {
            outputStream.write(byArray, 0, n5);
        }
    }

    private final byte[] _getBinaryFromString(Base64Variant base64Variant) throws IOException {
        if (this._tokenIncomplete) {
            this._finishToken();
        }
        if (this._binaryValue == null) {
            ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder();
            this._decodeBase64(this.getText(), byteArrayBuilder, base64Variant);
            this._binaryValue = byteArrayBuilder.toByteArray();
        }
        return this._binaryValue;
    }

    protected final JsonToken _handleFieldName() throws IOException {
        int n2;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        this._typeAsInt = n2 = this._inputBuffer[this._inputPtr++] & 0xFF;
        switch (n2 >> 6) {
            case 0: {
                switch (n2) {
                    case 32: {
                        this._streamReadContext.setCurrentName("");
                        return JsonToken.FIELD_NAME;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        int n3;
                        if (this._inputPtr >= this._inputEnd) {
                            this._loadMoreGuaranteed();
                        }
                        if ((n3 = ((n2 & 3) << 8) + (this._inputBuffer[this._inputPtr++] & 0xFF)) >= this._seenNameCount) {
                            this._reportInvalidSharedName(n3);
                        }
                        this._streamReadContext.setCurrentName(this._seenNames[n3]);
                        return JsonToken.FIELD_NAME;
                    }
                    case 52: {
                        this._handleLongFieldName();
                        return JsonToken.FIELD_NAME;
                    }
                }
                break;
            }
            case 1: {
                int n4 = n2 & 0x3F;
                if (n4 >= this._seenNameCount) {
                    this._reportInvalidSharedName(n4);
                }
                this._streamReadContext.setCurrentName(this._seenNames[n4]);
                return JsonToken.FIELD_NAME;
            }
            case 2: {
                int n5 = 1 + (n2 & 0x3F);
                String string = this._findOrDecodeShortAsciiName(n5);
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = string;
                }
                this._streamReadContext.setCurrentName(string);
                return JsonToken.FIELD_NAME;
            }
            case 3: {
                if ((n2 &= 0x3F) > 55) {
                    if (n2 != 59) break;
                    if (!this._streamReadContext.inObject()) {
                        this._reportMismatchedEndMarker(125, ']');
                    }
                    this._streamReadContext = this._streamReadContext.getParent();
                    return JsonToken.END_OBJECT;
                }
                int n6 = n2 + 2;
                String string = this._findOrDecodeShortUnicodeName(n6);
                if (this._seenNames != null) {
                    if (this._seenNameCount >= this._seenNames.length) {
                        this._seenNames = this._expandSeenNames(this._seenNames);
                    }
                    this._seenNames[this._seenNameCount++] = string;
                }
                this._streamReadContext.setCurrentName(string);
                return JsonToken.FIELD_NAME;
            }
        }
        throw this._constructReadException("Invalid type marker byte 0x%s for expected field name (or END_OBJECT marker)", Integer.toHexString(this._typeAsInt));
    }

    private String _findOrDecodeShortAsciiName(int n2) throws IOException {
        if (this._inputEnd - this._inputPtr < n2) {
            this._loadToHaveAtLeast(n2);
        }
        if (this._symbolsCanonical) {
            String string = this._findDecodedFromSymbols(n2);
            if (string != null) {
                this._inputPtr += n2;
            } else {
                string = this._decodeShortAsciiName(n2);
                string = this._addDecodedToSymbols(n2, string);
            }
            return string;
        }
        return this._decodeShortAsciiName(n2);
    }

    private String _findOrDecodeShortUnicodeName(int n2) throws IOException {
        if (this._inputEnd - this._inputPtr < n2) {
            this._loadToHaveAtLeast(n2);
        }
        if (this._symbolsCanonical) {
            String string = this._findDecodedFromSymbols(n2);
            if (string != null) {
                this._inputPtr += n2;
            } else {
                string = this._decodeShortUnicodeName(n2);
                string = this._addDecodedToSymbols(n2, string);
            }
            return string;
        }
        return this._decodeShortUnicodeName(n2);
    }

    private final String[] _expandSeenNames(String[] stringArray) {
        String[] stringArray2;
        int n2 = stringArray.length;
        if (n2 == 0) {
            stringArray2 = new String[64];
        } else if (n2 == 1024) {
            stringArray2 = stringArray;
            this._seenNameCount = 0;
        } else {
            int n3 = n2 == 64 ? 256 : 1024;
            stringArray2 = Arrays.copyOf(stringArray, n3);
        }
        return stringArray2;
    }

    private final String _addDecodedToSymbols(int n2, String string) throws IOException {
        if (n2 < 5) {
            return this._symbols.addName(string, this._quad1);
        }
        if (n2 < 9) {
            return this._symbols.addName(string, this._quad1, this._quad2);
        }
        if (n2 < 13) {
            return this._symbols.addName(string, this._quad1, this._quad2, this._quad3);
        }
        int n3 = n2 + 3 >> 2;
        return this._symbols.addName(string, this._quadBuffer, n3);
    }

    private final String _decodeShortAsciiName(int n2) throws IOException {
        int n3;
        if (JDK11_OR_LATER) {
            int n4 = this._inputPtr;
            this._inputPtr = n4 + n2;
            String string = new String(this._inputBuffer, n4, n2, StandardCharsets.US_ASCII);
            this._textBuffer.resetWithString(string);
            return string;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n5 = 0;
        byte[] byArray = this._inputBuffer;
        int n6 = n3 + n2;
        for (n3 = this._inputPtr; n3 < n6; ++n3) {
            cArray[n5++] = (char)byArray[n3];
        }
        this._inputPtr = n3;
        return this._textBuffer.setCurrentAndReturn(n2);
    }

    private final String _decodeShortUnicodeName(int n2) throws IOException {
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n4 = this._inputPtr;
        int[] nArray = SmileConstants.sUtf8UnitLengths;
        byte[] byArray = this._inputBuffer;
        int n5 = n4 + n2;
        while (n4 < n5) {
            int n6;
            int n7;
            if ((n7 = nArray[n6 = byArray[n4++] & 0xFF]) != 0) {
                if (n4 + n7 > n5) {
                    int n8 = n2 - (n5 - n4) - 1;
                    this._reportTruncatedUTF8InName(n2, n8, n6, n7);
                }
                switch (n7) {
                    case 1: {
                        n6 = (n6 & 0x1F) << 6 | byArray[n4++] & 0x3F;
                        break;
                    }
                    case 2: {
                        n6 = (n6 & 0xF) << 12 | (byArray[n4++] & 0x3F) << 6 | byArray[n4++] & 0x3F;
                        break;
                    }
                    case 3: {
                        n6 = (n6 & 7) << 18 | (byArray[n4++] & 0x3F) << 12 | (byArray[n4++] & 0x3F) << 6 | byArray[n4++] & 0x3F;
                        cArray[n3++] = (char)(0xD800 | (n6 -= 65536) >> 10);
                        n6 = 0xDC00 | n6 & 0x3FF;
                        break;
                    }
                    default: {
                        this._inputPtr = n4;
                        throw this._constructReadException("Invalid byte 0x%02X in short Unicode text block", n6);
                    }
                }
            }
            cArray[n3++] = (char)n6;
        }
        this._inputPtr += n2;
        return this._textBuffer.setCurrentAndReturn(n3);
    }

    private final String _decodeLongUnicodeName(int[] nArray, int n2, int n3, boolean bl2) throws IOException {
        int n4;
        int n5 = n2 & 3;
        if (n5 > 0) {
            n4 = nArray[n3 - 1];
            nArray[n3 - 1] = n4 << (4 - n5 << 3);
        } else {
            n4 = 0;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            int n8 = nArray[n7 >> 2];
            int n9 = n7 & 3;
            n8 = n8 >> (3 - n9 << 3) & 0xFF;
            ++n7;
            if (n8 > 127) {
                int n10;
                if ((n8 & 0xE0) == 192) {
                    n8 &= 0x1F;
                    n10 = 1;
                } else if ((n8 & 0xF0) == 224) {
                    n8 &= 0xF;
                    n10 = 2;
                } else if ((n8 & 0xF8) == 240) {
                    n8 &= 7;
                    n10 = 3;
                } else {
                    this._reportInvalidInitial(n8);
                    n8 = 1;
                    n10 = 1;
                }
                if (n7 + n10 > n2) {
                    this._reportInvalidEOF(" in long field name", JsonToken.FIELD_NAME);
                }
                int n11 = nArray[n7 >> 2];
                n9 = n7 & 3;
                ++n7;
                if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                    this._reportInvalidOther(n11);
                }
                n8 = n8 << 6 | n11 & 0x3F;
                if (n10 > 1) {
                    n11 = nArray[n7 >> 2];
                    n9 = n7 & 3;
                    ++n7;
                    if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                        this._reportInvalidOther(n11);
                    }
                    n8 = n8 << 6 | n11 & 0x3F;
                    if (n10 > 2) {
                        n11 = nArray[n7 >> 2];
                        n9 = n7 & 3;
                        ++n7;
                        if (((n11 >>= 3 - n9 << 3) & 0xC0) != 128) {
                            this._reportInvalidOther(n11 & 0xFF);
                        }
                        n8 = n8 << 6 | n11 & 0x3F;
                    }
                }
                if (n10 > 2) {
                    n8 -= 65536;
                    if (n6 >= cArray.length) {
                        cArray = this._textBuffer.expandCurrentSegment();
                    }
                    cArray[n6++] = (char)(55296 + (n8 >> 10));
                    n8 = 0xDC00 | n8 & 0x3FF;
                }
            }
            if (n6 >= cArray.length) {
                cArray = this._textBuffer.expandCurrentSegment();
            }
            cArray[n6++] = (char)n8;
        }
        String string = new String(cArray, 0, n6);
        if (n5 > 0) {
            nArray[n3 - 1] = n4;
        }
        if (bl2) {
            return this._symbols.addName(string, nArray, n3);
        }
        return string;
    }

    private final String _handleLongFieldName() throws IOException {
        String string;
        int n2;
        byte[] byArray = this._inputBuffer;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (-4 == (n2 = byArray[this._inputPtr++])) {
                n4 = 0;
                break;
            }
            n5 = n2 & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (-4 == (n2 = byArray[this._inputPtr++])) {
                n4 = 1;
                break;
            }
            n5 = n5 << 8 | n2 & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (-4 == (n2 = byArray[this._inputPtr++])) {
                n4 = 2;
                break;
            }
            n5 = n5 << 8 | n2 & 0xFF;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if (-4 == (n2 = byArray[this._inputPtr++])) {
                n4 = 3;
                break;
            }
            n5 = n5 << 8 | n2 & 0xFF;
            if (n3 >= this._quadBuffer.length) {
                this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            this._quadBuffer[n3++] = n5;
        }
        n2 = n3 << 2;
        if (n4 > 0) {
            if (n3 >= this._quadBuffer.length) {
                this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, this._quadBuffer.length + 256);
            }
            n5 = SmileParser._padLastQuad(n5, n4);
            this._quadBuffer[n3++] = n5;
            n2 += n4;
        }
        String string2 = string = this._symbolsCanonical ? this._symbols.findName(this._quadBuffer, n3) : null;
        if (string == null) {
            string = this._decodeLongUnicodeName(this._quadBuffer, n2, n3, this._symbolsCanonical);
        }
        if (this._seenNames != null) {
            if (this._seenNameCount >= this._seenNames.length) {
                this._seenNames = this._expandSeenNames(this._seenNames);
            }
            this._seenNames[this._seenNameCount++] = string;
        }
        this._streamReadContext.setCurrentName(string);
        return string;
    }

    private final String _findDecodedFromSymbols(int n2) throws IOException {
        if (n2 < 5) {
            int n3 = this._inputPtr;
            byte[] byArray = this._inputBuffer;
            int n4 = SmileParser._padQuadForNulls(byArray[n3]);
            if (n2 > 1) {
                n4 = (n4 << 8) + (byArray[++n3] & 0xFF);
                if (n2 > 2) {
                    n4 = (n4 << 8) + (byArray[++n3] & 0xFF);
                    if (n2 > 3) {
                        n4 = (n4 << 8) + (byArray[++n3] & 0xFF);
                    }
                }
            }
            this._quad1 = n4;
            return this._symbols.findName(n4);
        }
        byte[] byArray = this._inputBuffer;
        int n5 = this._inputPtr;
        int n6 = byArray[n5++] & 0xFF;
        n6 = n6 << 8 | byArray[n5++] & 0xFF;
        n6 = n6 << 8 | byArray[n5++] & 0xFF;
        n6 = n6 << 8 | byArray[n5++] & 0xFF;
        if (n2 < 9) {
            int n7 = SmileParser._padQuadForNulls(byArray[n5++]);
            int n8 = n2 - 5;
            if (n8 > 0) {
                n7 = (n7 << 8) + (byArray[n5++] & 0xFF);
                if (n8 > 1) {
                    n7 = (n7 << 8) + (byArray[n5++] & 0xFF);
                    if (n8 > 2) {
                        n7 = (n7 << 8) + (byArray[n5++] & 0xFF);
                    }
                }
            }
            this._quad1 = n6;
            this._quad2 = n7;
            return this._symbols.findName(n6, n7);
        }
        int n9 = byArray[n5++] & 0xFF;
        n9 = n9 << 8 | byArray[n5++] & 0xFF;
        n9 = n9 << 8 | byArray[n5++] & 0xFF;
        n9 = n9 << 8 | byArray[n5++] & 0xFF;
        if (n2 < 13) {
            int n10 = SmileParser._padQuadForNulls(byArray[n5++]);
            int n11 = n2 - 9;
            if (n11 > 0) {
                n10 = (n10 << 8) + (byArray[n5++] & 0xFF);
                if (n11 > 1) {
                    n10 = (n10 << 8) + (byArray[n5++] & 0xFF);
                    if (n11 > 2) {
                        n10 = (n10 << 8) + (byArray[n5++] & 0xFF);
                    }
                }
            }
            this._quad1 = n6;
            this._quad2 = n9;
            this._quad3 = n10;
            return this._symbols.findName(n6, n9, n10);
        }
        return this._findDecodedFixed12(n2, n6, n9);
    }

    private final String _findDecodedFixed12(int n2, int n3, int n4) throws IOException {
        int n5;
        int n6 = n2 + 3 >> 2;
        if (n6 > this._quadBuffer.length) {
            this._quadBuffer = SmileParser._growArrayTo(this._quadBuffer, n6);
        }
        this._quadBuffer[0] = n3;
        this._quadBuffer[1] = n4;
        n6 = 2;
        int n7 = this._inputPtr + 8;
        n2 -= 8;
        byte[] byArray = this._inputBuffer;
        do {
            n5 = byArray[n7++] & 0xFF;
            n5 = n5 << 8 | byArray[n7++] & 0xFF;
            n5 = n5 << 8 | byArray[n7++] & 0xFF;
            n5 = n5 << 8 | byArray[n7++] & 0xFF;
            this._quadBuffer[n6++] = n5;
        } while ((n2 -= 4) > 3);
        if (n2 > 0) {
            n5 = SmileParser._padQuadForNulls(byArray[n7]);
            if (n2 > 1) {
                n5 = (n5 << 8) + (byArray[++n7] & 0xFF);
                if (n2 > 2) {
                    n5 = (n5 << 8) + (byArray[++n7] & 0xFF);
                }
            }
            this._quadBuffer[n6++] = n5;
        }
        return this._symbols.findName(this._quadBuffer, n6);
    }

    private static int[] _growArrayTo(int[] nArray, int n2) {
        int n3 = n2 + 4;
        if (nArray == null) {
            return new int[n3];
        }
        return Arrays.copyOf(nArray, n3);
    }

    private static final int _padLastQuad(int n2, int n3) {
        return n3 == 4 ? n2 : n2 | -1 << (n3 << 3);
    }

    private static final int _padQuadForNulls(int n2) {
        return n2 & 0xFF | 0xFFFFFF00;
    }

    @Override
    protected void _parseNumericValue() throws IOException {
        if (!this._tokenIncomplete) {
            this._reportError("Internal error: number token (%s) decoded, no value set", (Object)this._currToken);
        }
        this._tokenIncomplete = false;
        int n2 = this._typeAsInt;
        if (n2 >> 5 != 1) {
            this._reportError("Current token (%s) not numeric, can not use numeric value accessors", (Object)this._currToken);
        }
        this._finishNumberToken(n2);
    }

    protected final void _finishToken() throws IOException {
        this._tokenIncomplete = false;
        int n2 = this._typeAsInt;
        int n3 = n2 >> 5;
        if (n3 == 1) {
            this._finishNumberToken(n2);
            return;
        }
        if (n3 <= 3) {
            this._decodeShortAsciiValue(1 + (n2 & 0x3F));
            return;
        }
        if (n3 <= 5) {
            this._decodeShortUnicodeValue(2 + (n2 & 0x3F));
            return;
        }
        if (n3 == 7) {
            switch ((n2 &= 0x1F) >> 2) {
                case 0: {
                    this._decodeLongAsciiValue();
                    return;
                }
                case 1: {
                    this._decodeLongUnicodeValue();
                    return;
                }
                case 2: {
                    this._binaryValue = this._read7BitBinaryWithLength();
                    return;
                }
                case 7: {
                    this._binaryValue = this._finishBinaryRaw();
                    return;
                }
            }
        }
        this._throwInternal();
    }

    protected final void _finishNumberToken(int n2) throws IOException {
        switch (n2 & 0x1F) {
            case 4: {
                this._finishInt();
                return;
            }
            case 5: {
                this._finishLong();
                return;
            }
            case 6: {
                this._finishBigInteger();
                return;
            }
            case 8: {
                this._finishFloat();
                return;
            }
            case 9: {
                this._finishDouble();
                return;
            }
            case 10: {
                this._finishBigDecimal();
                return;
            }
        }
        this._throwInternal();
    }

    private final void _finishInt() throws IOException {
        int n2;
        this._numTypesValid = 1;
        this._numberType = JsonParser.NumberType.INT;
        int n3 = this._inputPtr;
        if (n3 + 5 >= this._inputEnd) {
            this._finishIntSlow();
            return;
        }
        if ((n2 = this._inputBuffer[n3++]) < 0) {
            n2 &= 0x3F;
        } else {
            byte by2;
            if ((by2 = this._inputBuffer[n3++]) >= 0) {
                n2 = (n2 << 7) + by2;
                if ((by2 = this._inputBuffer[n3++]) >= 0) {
                    n2 = (n2 << 7) + by2;
                    if ((by2 = this._inputBuffer[n3++]) >= 0) {
                        n2 = (n2 << 7) + by2;
                        if ((by2 = this._inputBuffer[n3++]) >= 0) {
                            this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
                        }
                    }
                }
            }
            n2 = (n2 << 6) + (by2 & 0x3F);
        }
        this._inputPtr = n3;
        this._numberInt = SmileUtil.zigzagDecode(n2);
    }

    private final void _finishIntSlow() throws IOException {
        int n2;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if ((n2 = this._inputBuffer[this._inputPtr++]) < 0) {
            n2 &= 0x3F;
        } else {
            byte by2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((by2 = this._inputBuffer[this._inputPtr++]) >= 0) {
                n2 = (n2 << 7) + by2;
                if (this._inputPtr >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                }
                if ((by2 = this._inputBuffer[this._inputPtr++]) >= 0) {
                    n2 = (n2 << 7) + by2;
                    if (this._inputPtr >= this._inputEnd) {
                        this._loadMoreGuaranteed();
                    }
                    if ((by2 = this._inputBuffer[this._inputPtr++]) >= 0) {
                        n2 = (n2 << 7) + by2;
                        if (this._inputPtr >= this._inputEnd) {
                            this._loadMoreGuaranteed();
                        }
                        if ((by2 = this._inputBuffer[this._inputPtr++]) >= 0) {
                            this._reportError("Corrupt input; 32-bit VInt extends beyond 5 data bytes");
                        }
                    }
                }
            }
            n2 = (n2 << 6) + (by2 & 0x3F);
        }
        this._numberInt = SmileUtil.zigzagDecode(n2);
    }

    private final void _finishLong() throws IOException {
        this._numTypesValid = 2;
        this._numberType = JsonParser.NumberType.LONG;
        int n2 = this._inputPtr;
        int n3 = n2 + 11;
        if (n3 >= this._inputEnd) {
            this._finishLongSlow();
            return;
        }
        int n4 = this._inputBuffer[n2++];
        n4 = (n4 << 7) + this._inputBuffer[n2++];
        n4 = (n4 << 7) + this._inputBuffer[n2++];
        n4 = (n4 << 7) + this._inputBuffer[n2++];
        long l2 = n4;
        do {
            byte by2;
            if ((by2 = this._inputBuffer[n2++]) < 0) {
                l2 = (l2 << 6) + (long)(by2 & 0x3F);
                this._inputPtr = n2;
                this._numberLong = SmileUtil.zigzagDecode(l2);
                return;
            }
            l2 = (l2 << 7) + (long)by2;
        } while (n2 < n3);
        this._reportError("Corrupt input; 64-bit VInt extends beyond 11 data bytes");
    }

    private final void _finishLongSlow() throws IOException {
        long l2 = this._fourBytesToInt();
        while (true) {
            byte by2;
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((by2 = this._inputBuffer[this._inputPtr++]) < 0) {
                l2 = (l2 << 6) + (long)(by2 & 0x3F);
                this._numberLong = SmileUtil.zigzagDecode(l2);
                return;
            }
            l2 = (l2 << 7) + (long)by2;
        }
    }

    private final int _fourBytesToInt() throws IOException {
        int n2 = this._inputPtr;
        if (n2 + 3 >= this._inputEnd) {
            return this._fourBytesToIntSlow();
        }
        int n3 = this._inputBuffer[n2++];
        n3 = (n3 << 7) + this._inputBuffer[n2++];
        n3 = (n3 << 7) + this._inputBuffer[n2++];
        n3 = (n3 << 7) + this._inputBuffer[n2++];
        this._inputPtr = n2;
        return n3;
    }

    private final int _fourBytesToIntSlow() throws IOException {
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        int n2 = this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        n2 = (n2 << 7) + this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        n2 = (n2 << 7) + this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        return (n2 << 7) + this._inputBuffer[this._inputPtr++];
    }

    private final void _finishBigInteger() throws IOException {
        byte[] byArray = this._read7BitBinaryWithLength();
        if (byArray.length == 0) {
            this._numberBigInt = BigInteger.ZERO;
        } else {
            this.streamReadConstraints().validateIntegerLength(byArray.length);
            this._numberBigInt = new BigInteger(byArray);
        }
        this._numTypesValid = 4;
        this._numberType = JsonParser.NumberType.BIG_INTEGER;
    }

    private final void _finishFloat() throws IOException {
        float f2;
        int n2 = this._fourBytesToInt();
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        n2 = (n2 << 7) + this._inputBuffer[this._inputPtr++];
        this._numberFloat = f2 = Float.intBitsToFloat(n2);
        this._numberType = JsonParser.NumberType.FLOAT;
        this._numTypesValid = 32;
    }

    private final void _finishDouble() throws IOException {
        long l2 = this._fourBytesToInt();
        long l3 = (l2 << 28) + (long)this._fourBytesToInt();
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        l3 = (l3 << 7) + (long)this._inputBuffer[this._inputPtr++];
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        l3 = (l3 << 7) + (long)this._inputBuffer[this._inputPtr++];
        this._numberDouble = Double.longBitsToDouble(l3);
        this._numberType = JsonParser.NumberType.DOUBLE;
        this._numTypesValid = 8;
    }

    private final void _finishBigDecimal() throws IOException {
        int n2 = SmileUtil.zigzagDecode(this._readUnsignedVInt());
        byte[] byArray = this._read7BitBinaryWithLength();
        if (byArray.length == 0) {
            this._numberBigDecimal = BigDecimal.ZERO;
        } else {
            this.streamReadConstraints().validateFPLength(byArray.length);
            BigInteger bigInteger = new BigInteger(byArray);
            this._numberBigDecimal = new BigDecimal(bigInteger, n2);
        }
        this._numTypesValid = 16;
        this._numberType = JsonParser.NumberType.BIG_DECIMAL;
    }

    protected final int _readUnsignedVInt() throws IOException {
        int n2;
        if (this._inputPtr + 5 > this._inputEnd) {
            return this._readUnsignedVIntSlow();
        }
        if ((n2 = this._inputBuffer[this._inputPtr++]) < 0) {
            return n2 & 0x3F;
        }
        int n3 = n2;
        if ((n2 = this._inputBuffer[this._inputPtr++]) < 0) {
            return (n3 << 6) + (n2 & 0x3F);
        }
        n3 = (n3 << 7) + n2;
        if ((n2 = this._inputBuffer[this._inputPtr++]) < 0) {
            return (n3 << 6) + (n2 & 0x3F);
        }
        n3 = (n3 << 7) + n2;
        if ((n2 = this._inputBuffer[this._inputPtr++]) < 0) {
            return (n3 << 6) + (n2 & 0x3F);
        }
        n3 = (n3 << 7) + n2;
        if ((n2 = this._inputBuffer[this._inputPtr++]) >= 0 || n3 >>> 25 != 0) {
            this._reportInvalidUnsignedVInt(n3 >>> 21, n2);
        }
        return (n3 << 6) + (n2 & 0x3F);
    }

    protected final int _readUnsignedVIntSlow() throws IOException {
        byte by2;
        int n2 = 0;
        int n3 = 0;
        do {
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            if ((by2 = this._inputBuffer[this._inputPtr++]) < 0) {
                n2 = (n2 << 6) + (by2 & 0x3F);
                return n2;
            }
            n2 = (n2 << 7) + by2;
        } while (++n3 < 4);
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if ((by2 = this._inputBuffer[this._inputPtr++]) >= 0 || n2 >>> 25 != 0) {
            this._reportInvalidUnsignedVInt(n2 >>> 21, by2);
        }
        return (n2 << 6) + (by2 & 0x3F);
    }

    protected final void _reportInvalidUnsignedVInt(int n2, int n3) throws IOException {
        if (n3 >= 0) {
            this._reportError("Overflow in VInt (current token %s): 5th byte (0x%2X) of 5-byte sequence must have its highest bit set to indicate end", (Object)this.currentToken(), n3);
        }
        this._reportError("Overflow in VInt (current token %s): 1st byte (0x%2X) of 5-byte sequence must have its top 4 bits zeroes", (Object)this.currentToken(), n2);
    }

    protected final String _decodeShortAsciiValue(int n2) throws IOException {
        int n3;
        if (this._inputEnd - this._inputPtr < n2) {
            this._loadToHaveAtLeast(n2);
        }
        if (JDK11_OR_LATER) {
            int n4 = this._inputPtr;
            this._inputPtr = n4 + n2;
            String string = new String(this._inputBuffer, n4, n2, StandardCharsets.US_ASCII);
            this._textBuffer.resetWithString(string);
            return string;
        }
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n5 = 0;
        byte[] byArray = this._inputBuffer;
        int n6 = n3 + n2;
        for (n3 = this._inputPtr; n3 < n6; ++n3) {
            cArray[n5++] = (char)byArray[n3];
        }
        this._inputPtr = n3;
        return this._textBuffer.setCurrentAndReturn(n2);
    }

    protected final String _decodeShortUnicodeValue(int n2) throws IOException {
        if (this._inputEnd - this._inputPtr < n2) {
            this._loadToHaveAtLeast(n2);
        }
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int n4 = this._inputPtr;
        this._inputPtr += n2;
        int[] nArray = SmileConstants.sUtf8UnitLengths;
        byte[] byArray = this._inputBuffer;
        int n5 = n4 + n2;
        while (n4 < n5) {
            int n6;
            if ((n6 = byArray[n4++]) >= 0) {
                cArray[n3++] = (char)n6;
                continue;
            }
            int n7 = nArray[n6 &= 0xFF];
            if (n4 + n7 > n5) {
                int n8 = n2 - (n5 - n4) - 1;
                return this._reportTruncatedUTF8InString(n2, n8, n6, n7);
            }
            switch (n7) {
                case 1: {
                    n6 = (n6 & 0x1F) << 6 | byArray[n4++] & 0x3F;
                    break;
                }
                case 2: {
                    n6 = (n6 & 0xF) << 12 | (byArray[n4++] & 0x3F) << 6 | byArray[n4++] & 0x3F;
                    break;
                }
                case 3: {
                    n6 = (n6 & 7) << 18 | (byArray[n4++] & 0x3F) << 12 | (byArray[n4++] & 0x3F) << 6 | byArray[n4++] & 0x3F;
                    cArray[n3++] = (char)(0xD800 | (n6 -= 65536) >> 10);
                    n6 = 0xDC00 | n6 & 0x3FF;
                    break;
                }
                default: {
                    throw this._constructReadException("Invalid byte 0x%02X in short Unicode text block", n6);
                }
            }
            cArray[n3++] = (char)n6;
        }
        return this._textBuffer.setCurrentAndReturn(n3);
    }

    private final void _decodeLongAsciiValue() throws IOException {
        int n2;
        int n3 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        block0: while (true) {
            if (this._inputPtr >= this._inputEnd) {
                this._loadMoreGuaranteed();
            }
            n2 = this._inputPtr;
            int n4 = this._inputEnd - n2;
            if (n3 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n3 = 0;
            }
            n4 = Math.min(n4, cArray.length - n3);
            do {
                byte by2;
                if ((by2 = this._inputBuffer[n2++]) == -4) break block0;
                cArray[n3++] = (char)by2;
            } while (--n4 > 0);
            this._inputPtr = n2;
        }
        this._inputPtr = n2;
        this._textBuffer.setCurrentLength(n3);
    }

    private final void _decodeLongUnicodeValue() throws IOException {
        int n2 = 0;
        char[] cArray = this._textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = SmileConstants.sUtf8UnitLengths;
        byte[] byArray = this._inputBuffer;
        while (true) {
            int n3;
            int n4;
            block14: {
                int n5;
                int n6;
                if ((n4 = this._inputPtr) >= this._inputEnd) {
                    this._loadMoreGuaranteed();
                    n4 = this._inputPtr;
                }
                if (n2 >= cArray.length) {
                    cArray = this._textBuffer.finishCurrentSegment();
                    n2 = 0;
                }
                if ((n6 = n4 + (cArray.length - n2)) < (n5 = this._inputEnd)) {
                    n5 = n6;
                }
                while (n4 < n5) {
                    if (nArray[n3 = byArray[n4++] & 0xFF] == 0) {
                        cArray[n2++] = (char)n3;
                        continue;
                    }
                    break block14;
                }
                this._inputPtr = n4;
                continue;
            }
            this._inputPtr = n4;
            if (n3 == 252) break;
            switch (nArray[n3]) {
                case 1: {
                    n3 = this._decodeUtf8_2(n3);
                    break;
                }
                case 2: {
                    if (this._inputEnd - this._inputPtr >= 2) {
                        n3 = this._decodeUtf8_3fast(n3);
                        break;
                    }
                    n3 = this._decodeUtf8_3(n3);
                    break;
                }
                case 3: {
                    n3 = this._decodeUtf8_4(n3);
                    cArray[n2++] = (char)(0xD800 | n3 >> 10);
                    if (n2 >= cArray.length) {
                        cArray = this._textBuffer.finishCurrentSegment();
                        n2 = 0;
                    }
                    n3 = 0xDC00 | n3 & 0x3FF;
                    break;
                }
                default: {
                    this._reportInvalidChar(n3);
                }
            }
            if (n2 >= cArray.length) {
                cArray = this._textBuffer.finishCurrentSegment();
                n2 = 0;
            }
            cArray[n2++] = (char)n3;
        }
        this._textBuffer.setCurrentLength(n2);
    }

    private final byte[] _finishBinaryRaw() throws IOException {
        int n2 = this._readUnsignedVInt();
        if (n2 > 250000) {
            return this._finishBinaryRawLong(n2);
        }
        int n3 = n2;
        byte[] byArray = new byte[n2];
        int n4 = 0;
        while (n2 > 0) {
            if (this._inputPtr >= this._inputEnd && !this._loadMore()) {
                this._reportIncompleteBinaryReadRaw(n3, n4);
            }
            int n5 = Math.min(n2, this._inputEnd - this._inputPtr);
            System.arraycopy(this._inputBuffer, this._inputPtr, byArray, n4, n5);
            this._inputPtr += n5;
            n4 += n5;
            n2 -= n5;
        }
        return byArray;
    }

    protected byte[] _finishBinaryRawLong(int n2) throws IOException {
        try (ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(125000);){
            int n3;
            for (int i2 = n2; i2 > 0; i2 -= n3) {
                int n4 = this._inputEnd - this._inputPtr;
                if (n4 <= 0) {
                    if (!this._loadMore()) {
                        this._reportIncompleteBinaryReadRaw(n2, n2 - i2);
                    }
                    n4 = this._inputEnd - this._inputPtr;
                }
                n3 = Math.min(n4, i2);
                byteArrayBuilder.write(this._inputBuffer, this._inputPtr, n3);
                this._inputPtr += n3;
            }
            byte[] byArray = byteArrayBuilder.toByteArray();
            return byArray;
        }
    }

    private final byte[] _read7BitBinaryWithLength() throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = this._readUnsignedVInt();
        if (n5 > 250000) {
            return this._finishBinary7BitLong(n5);
        }
        byte[] byArray = new byte[n5];
        int n6 = n5 - 7;
        int n7 = 0;
        while (n7 <= n6) {
            if (this._inputEnd - this._inputPtr < 8 && (n4 = this._tryToLoadToHaveAtLeast(8)) > 0) {
                this._reportIncompleteBinaryRead7Bit(n5, n7);
            }
            n4 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
            n3 = this._inputBuffer[this._inputPtr++];
            n2 = ((n3 & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
            byArray[n7++] = (byte)((n4 += n3 >> 3) >> 24);
            byArray[n7++] = (byte)(n4 >> 16);
            byArray[n7++] = (byte)(n4 >> 8);
            byArray[n7++] = (byte)n4;
            byArray[n7++] = (byte)(n2 >> 16);
            byArray[n7++] = (byte)(n2 >> 8);
            byArray[n7++] = (byte)n2;
        }
        n4 = byArray.length - n7;
        if (n4 > 0) {
            if (this._inputEnd - this._inputPtr < n4 + 1 && (n3 = this._tryToLoadToHaveAtLeast(n4 + 1)) > 0) {
                this._reportIncompleteBinaryRead7Bit(n5, n7);
            }
            n3 = this._inputBuffer[this._inputPtr++];
            for (n2 = 1; n2 < n4; ++n2) {
                n3 = (n3 << 7) + this._inputBuffer[this._inputPtr++];
                byArray[n7++] = (byte)(n3 >> 7 - n2);
            }
            byArray[n7] = (byte)((n3 <<= n4) + this._inputBuffer[this._inputPtr++]);
        }
        return byArray;
    }

    protected byte[] _finishBinary7BitLong(int n2) throws IOException {
        try (ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(125000);){
            int n3;
            int n4;
            int n5;
            byte[] byArray = new byte[896];
            int n6 = 0;
            for (n5 = n2; n5 >= 7; n5 -= 7) {
                if (this._inputEnd - this._inputPtr < 8 && (n4 = this._tryToLoadToHaveAtLeast(8)) > 0) {
                    this._reportIncompleteBinaryRead7Bit(n2, byteArrayBuilder.size() + n6);
                }
                n4 = (this._inputBuffer[this._inputPtr++] << 25) + (this._inputBuffer[this._inputPtr++] << 18) + (this._inputBuffer[this._inputPtr++] << 11) + (this._inputBuffer[this._inputPtr++] << 4);
                n3 = this._inputBuffer[this._inputPtr++];
                int n7 = ((n3 & 7) << 21) + (this._inputBuffer[this._inputPtr++] << 14) + (this._inputBuffer[this._inputPtr++] << 7) + this._inputBuffer[this._inputPtr++];
                byArray[n6++] = (byte)((n4 += n3 >> 3) >> 24);
                byArray[n6++] = (byte)(n4 >> 16);
                byArray[n6++] = (byte)(n4 >> 8);
                byArray[n6++] = (byte)n4;
                byArray[n6++] = (byte)(n7 >> 16);
                byArray[n6++] = (byte)(n7 >> 8);
                byArray[n6++] = (byte)n7;
                if (n6 < byArray.length) continue;
                byteArrayBuilder.write(byArray, 0, n6);
                n6 = 0;
            }
            if (n5 > 0) {
                if (this._inputEnd - this._inputPtr < n5 + 1) {
                    this._loadToHaveAtLeast(n5 + 1);
                }
                n4 = this._inputBuffer[this._inputPtr++];
                for (n3 = 1; n3 < n5; ++n3) {
                    n4 = (n4 << 7) + this._inputBuffer[this._inputPtr++];
                    byArray[n6++] = (byte)(n4 >> 7 - n3);
                }
                byArray[n6++] = (byte)((n4 <<= n5) + this._inputBuffer[this._inputPtr++]);
            }
            if (n6 > 0) {
                byteArrayBuilder.write(byArray, 0, n6);
            }
            byte[] byArray2 = byteArrayBuilder.toByteArray();
            return byArray2;
        }
    }

    protected void _skipIncomplete() throws IOException {
        this._tokenIncomplete = false;
        int n2 = this._typeAsInt;
        switch (n2 >> 5) {
            case 1: {
                switch ((n2 &= 0x1F) >> 2) {
                    case 1: {
                        switch (n2 & 3) {
                            case 1: {
                                this._skipBytes(4);
                            }
                            case 0: {
                                while (true) {
                                    int n3 = this._inputEnd;
                                    byte[] byArray = this._inputBuffer;
                                    while (this._inputPtr < n3) {
                                        if (byArray[this._inputPtr++] >= 0) continue;
                                        return;
                                    }
                                    this._loadMoreGuaranteed();
                                }
                            }
                            case 2: {
                                this._skip7BitBinary();
                                return;
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (n2 & 3) {
                            case 0: {
                                this._skipBytes(5);
                                return;
                            }
                            case 1: {
                                this._skipBytes(10);
                                return;
                            }
                            case 2: {
                                this._readUnsignedVInt();
                                this._skip7BitBinary();
                                return;
                            }
                        }
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                this._skipBytes(1 + (n2 & 0x3F));
                return;
            }
            case 4: 
            case 5: {
                this._skipBytes(2 + (n2 & 0x3F));
                return;
            }
            case 7: {
                switch ((n2 &= 0x1F) >> 2) {
                    case 0: 
                    case 1: {
                        while (true) {
                            int n4 = this._inputEnd;
                            byte[] byArray = this._inputBuffer;
                            while (this._inputPtr < n4) {
                                if (byArray[this._inputPtr++] != -4) continue;
                                return;
                            }
                            this._loadMoreGuaranteed();
                        }
                    }
                    case 2: {
                        this._skip7BitBinary();
                        return;
                    }
                    case 7: {
                        this._skipBytes(this._readUnsignedVInt());
                        return;
                    }
                }
            }
        }
        this._throwInternal();
    }

    protected void _skipBytes(int n2) throws IOException {
        while (true) {
            int n3 = Math.min(n2, this._inputEnd - this._inputPtr);
            this._inputPtr += n3;
            if ((n2 -= n3) <= 0) {
                return;
            }
            this._loadMoreGuaranteed();
        }
    }

    protected void _skip7BitBinary() throws IOException {
        int n2 = this._readUnsignedVInt();
        int n3 = n2 / 7;
        int n4 = n3 * 8;
        if ((n2 -= 7 * n3) > 0) {
            n4 += 1 + n2;
        }
        this._skipBytes(n4);
    }

    private final int _decodeUtf8_2(int n2) throws IOException {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        return (n2 & 0x1F) << 6 | by2 & 0x3F;
    }

    private final int _decodeUtf8_3(int n2) throws IOException {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        n2 &= 0xF;
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        int n3 = n2 << 6 | by2 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        n3 = n3 << 6 | by2 & 0x3F;
        return n3;
    }

    private final int _decodeUtf8_3fast(int n2) throws IOException {
        byte by2;
        n2 &= 0xF;
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        int n3 = n2 << 6 | by2 & 0x3F;
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        n3 = n3 << 6 | by2 & 0x3F;
        return n3;
    }

    private final int _decodeUtf8_4(int n2) throws IOException {
        byte by2;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        n2 = (n2 & 7) << 6 | by2 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        n2 = n2 << 6 | by2 & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this._loadMoreGuaranteed();
        }
        if (((by2 = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this._reportInvalidOther(by2 & 0xFF, this._inputPtr);
        }
        return (n2 << 6 | by2 & 0x3F) - 65536;
    }

    protected void _reportInvalidSharedName(int n2) throws IOException {
        if (this._seenNames == null) {
            this._reportError("Encountered shared name reference, even though document header explicitly declared no shared name references are included");
        }
        this._reportError("Invalid shared name reference " + n2 + "; only got " + this._seenNameCount + " names in buffer (invalid content)");
    }

    protected void _reportInvalidSharedStringValue(int n2) throws IOException {
        if (this._seenStringValues == null) {
            this._reportError("Encountered shared text value reference, even though document header did not declare shared text value references may be included");
        }
        this._reportError("Invalid shared text value reference " + n2 + "; only got " + this._seenStringValueCount + " names in buffer (invalid content)");
    }

    protected void _reportInvalidChar(int n2) throws JsonParseException {
        if (n2 < 32) {
            this._throwInvalidSpace(n2);
        }
        this._reportInvalidInitial(n2);
    }

    protected void _reportInvalidInitial(int n2) throws JsonParseException {
        this._reportError("Invalid UTF-8 start byte 0x" + Integer.toHexString(n2));
    }

    protected void _reportInvalidOther(int n2) throws JsonParseException {
        this._reportError("Invalid UTF-8 middle byte 0x" + Integer.toHexString(n2));
    }

    protected void _reportInvalidOther(int n2, int n3) throws JsonParseException {
        this._inputPtr = n3;
        this._reportInvalidOther(n2);
    }

    protected void _reportIncompleteBinaryReadRaw(int n2, int n3) throws IOException {
        this._reportInvalidEOF(String.format(" for Binary value (raw): expected %d bytes, only found %d", n2, n3), this.currentToken());
    }

    protected void _reportIncompleteBinaryRead7Bit(int n2, int n3) throws IOException {
        long l2 = (7L + 8L * (long)n2) / 7L;
        this._reportInvalidEOF(String.format(" for Binary value (7-bit): expected %d payload bytes (from %d encoded), only decoded %d", n2, l2, n3), this.currentToken());
    }

    protected String _reportTruncatedUTF8InString(int n2, int n3, int n4, int n5) throws IOException {
        throw this._constructReadException(String.format("Truncated UTF-8 character in Short Unicode String value (%d bytes): byte 0x%02X at offset #%d indicated %d more bytes needed", n2, n4, n3, n5));
    }

    protected String _reportTruncatedUTF8InName(int n2, int n3, int n4, int n5) throws IOException {
        throw this._constructReadException(String.format("Truncated UTF-8 character in Short Unicode Name (%d bytes): byte 0x%02X at offset #%d indicated %d more bytes needed", n2, n4, n3, n5));
    }

    private final JsonToken _eofAsNextToken() throws IOException {
        if (!this._streamReadContext.inRoot()) {
            this._handleEOF();
        }
        this.close();
        this._currToken = null;
        return null;
    }

    private void createChildArrayContext(int n2, int n3) throws IOException {
        this._streamReadContext = this._streamReadContext.createChildArrayContext(n2, n3);
        this.streamReadConstraints().validateNestingDepth(this._streamReadContext.getNestingDepth());
    }

    private void createChildObjectContext(int n2, int n3) throws IOException {
        this._streamReadContext = this._streamReadContext.createChildObjectContext(n2, n3);
        this.streamReadConstraints().validateNestingDepth(this._streamReadContext.getNestingDepth());
    }

    static {
        boolean bl2;
        try {
            String.class.getMethod("strip", new Class[0]);
            bl2 = true;
        }
        catch (Exception exception) {
            bl2 = false;
        }
        JDK11_OR_LATER = bl2;
    }

    public static enum Feature implements FormatFeature
    {
        REQUIRE_HEADER(true);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int n2 = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n2 |= feature.getMask();
            }
            return n2;
        }

        private Feature(boolean bl2) {
            this._defaultState = bl2;
            this._mask = 1 << this.ordinal();
        }

        @Override
        public boolean enabledByDefault() {
            return this._defaultState;
        }

        @Override
        public int getMask() {
            return this._mask;
        }

        @Override
        public boolean enabledIn(int n2) {
            return (n2 & this.getMask()) != 0;
        }
    }
}

