/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.io;

import java.io.OutputStream;

public class NoLockByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public NoLockByteArrayOutputStream() {
        this(32);
    }

    public NoLockByteArrayOutputStream(int size) {
        this.buf = new byte[size];
    }

    @Override
    public void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = NoLockByteArrayOutputStream.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = NoLockByteArrayOutputStream.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        return NoLockByteArrayOutputStream.copyOf(this.buf, this.count);
    }

    public int size() {
        return this.count;
    }
}

