/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.text;

import org.beetl.core.text.BeetlFragment;
import org.beetl.core.text.HtmlTagConfig;
import org.beetl.core.text.PlaceHolderDelimeter;
import org.beetl.core.text.ScriptDelimeter;
import org.beetl.core.text.TextFragment;
import org.beetl.core.text.TextParser;

public class Source {
    char[] cs = null;
    int p;
    int size = 0;
    PlaceHolderDelimeter pd;
    ScriptDelimeter sd;
    HtmlTagConfig htmlTagConfig;
    TextParser parser;
    int curLine = 0;
    boolean isSupportHtmlTag = false;
    int lastCrSize = 0;
    TextFragment lastTextFragment = null;
    BeetlFragment beetlFragment = null;

    public Source(char[] cs) {
        this.cs = cs;
        this.p = 0;
        this.size = cs.length;
    }

    public void init(TextParser parser, PlaceHolderDelimeter pd, ScriptDelimeter sd, HtmlTagConfig htmlTagConfig) {
        this.pd = pd;
        this.sd = sd;
        pd.setSource(this);
        sd.setSource(this);
        this.parser = parser;
        this.htmlTagConfig = htmlTagConfig;
        if (htmlTagConfig != null) {
            htmlTagConfig.init(this);
            this.isSupportHtmlTag = true;
        }
    }

    public String findCr() {
        this.p = 0;
        while (!this.isEof()) {
            int crCount = this.isMatchCR();
            if (crCount != 0) {
                return new String(this.consumeAndGetCR(crCount));
            }
            this.consume();
        }
        return null;
    }

    public boolean isPlaceHolderStart() {
        return this.pd.matchStart();
    }

    public boolean isPlaceHolderEnd(StringBuilder script) {
        return this.pd.matchEnd(script);
    }

    public boolean isScriptStart() {
        return this.sd.matchStart();
    }

    public boolean isScriptEnd(StringBuilder script) {
        return this.sd.matchEnd(script);
    }

    public boolean isHtmlTagStart() {
        return this.isSupportHtmlTag && this.htmlTagConfig.matchTagStart();
    }

    public boolean isHtmlTagEnd() {
        return this.isSupportHtmlTag && this.htmlTagConfig.matchTagEnd();
    }

    public boolean matchAndSKip(char[] text) {
        boolean isMatch;
        boolean bl = isMatch = this.isMatch(text) && !this.hasEscape();
        if (isMatch) {
            this.consume(text.length);
        }
        return isMatch;
    }

    public boolean matchAndSKipEnd(char[] text) {
        boolean isMatch;
        boolean bl = isMatch = this.isMatch(text) && !this.hasScriptEscape();
        if (isMatch) {
            this.consume(text.length);
        }
        return isMatch;
    }

    public boolean isSupportHtmlTag() {
        return this.isSupportHtmlTag;
    }

    protected void addLine() {
        ++this.curLine;
    }

    public boolean hasEscape() {
        if (this.p > 0) {
            if (this.cs[this.p - 1] == '\\') {
                if (this.p > 1) {
                    if (this.cs[this.p - 2] != '\\') {
                        this.removeTextEscape();
                        return true;
                    }
                    this.removeTextEscape();
                    return false;
                }
                this.removeTextEscape();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean hasScriptEscape() {
        if (this.p > 0) {
            if (this.cs[this.p - 1] == '\\') {
                if (this.p > 1) {
                    if (this.cs[this.p - 2] != '\\') {
                        this.removeScriptEscape();
                        return true;
                    }
                    this.removeScriptEscape();
                    return false;
                }
                this.removeScriptEscape();
                return true;
            }
            return false;
        }
        return false;
    }

    public void removeScriptEscape() {
        this.beetlFragment.removeEscape();
    }

    public void removeTextEscape() {
        this.lastTextFragment.removeTextEscape();
    }

    public boolean isMatch(char[] str) {
        int cur = this.p;
        for (int i = 0; i < str.length; ++i) {
            if (cur < this.size && this.cs[cur] == str[i]) {
                ++cur;
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isCrStart() {
        int crLength = this.isMatchCR();
        if (crLength == 0) {
            return false;
        }
        this.lastCrSize = crLength;
        return true;
    }

    public int isMatchCR() {
        char c = this.cs[this.p];
        if (c == '\n') {
            return 1;
        }
        if (c == '\r') {
            if (this.size > this.p + 1 && this.cs[this.p + 1] == '\n') {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public char consumeAndGet() {
        char c = this.get();
        this.consume();
        return c;
    }

    public char[] consumeAndGetCR(int size) {
        char[] cs = new char[size];
        for (int i = 0; i < size; ++i) {
            cs[i] = this.consumeAndGet();
        }
        this.addLine();
        return cs;
    }

    public void consume() {
        ++this.p;
    }

    public void consume(int x) {
        this.p += x;
    }

    public char get() {
        return this.cs[this.p];
    }

    public boolean isEof() {
        return this.p == this.size;
    }

    public void move(int p) {
        this.p = p;
    }

    public TextParser getParser() {
        return this.parser;
    }

    public void setParser(TextParser parser) {
        this.parser = parser;
    }

    public String toString() {
        return new String(this.cs, 0, this.p);
    }
}

