/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.io;

import java.lang.ref.SoftReference;
import org.beetl.core.io.NoLockStringWriter;

public class SoftReferenceWriter
extends NoLockStringWriter {
    public static int INIT_SIZE = 128;
    public static int MAX_SIZE = 512;
    public static boolean FIX_SIZE = false;
    static ThreadLocal<SoftReference<SoftReferenceWriter>> cache = new ThreadLocal<SoftReference<SoftReferenceWriter>>(){

        @Override
        protected SoftReference<SoftReferenceWriter> initialValue() {
            return new SoftReference<SoftReferenceWriter>(new SoftReferenceWriter(INIT_SIZE));
        }
    };

    public static SoftReferenceWriter local() {
        SoftReference<SoftReferenceWriter> softReference = cache.get();
        SoftReferenceWriter writer = softReference.get();
        if (writer == null) {
            writer = new SoftReferenceWriter(INIT_SIZE);
            cache.set(new SoftReference<SoftReferenceWriter>(writer));
        }
        return writer;
    }

    public SoftReferenceWriter(int size) {
        super(size);
    }

    @Override
    public String toString() {
        String str = new String(this.buf, 0, this.pos);
        this.clearCache();
        return str;
    }

    @Override
    public void close() {
        this.clearCache();
    }

    protected void clearCache() {
        this.pos = 0;
        if (FIX_SIZE && this.buf.length > MAX_SIZE) {
            this.buf = new char[INIT_SIZE];
        }
    }
}

