/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.view.MenuItem;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.view.MenuItemActionViewCollapseEvent;
import com.jakewharton.rxbinding2.view.MenuItemActionViewEvent;
import com.jakewharton.rxbinding2.view.MenuItemActionViewExpandEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Predicate;

final class MenuItemActionViewEventObservable
extends Observable<MenuItemActionViewEvent> {
    private final MenuItem menuItem;
    private final Predicate<? super MenuItemActionViewEvent> handled;

    MenuItemActionViewEventObservable(MenuItem menuItem, Predicate<? super MenuItemActionViewEvent> handled) {
        this.menuItem = menuItem;
        this.handled = handled;
    }

    protected void subscribeActual(Observer<? super MenuItemActionViewEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.menuItem, this.handled, observer);
        observer.onSubscribe((Disposable)listener);
        this.menuItem.setOnActionExpandListener((MenuItem.OnActionExpandListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements MenuItem.OnActionExpandListener {
        private final MenuItem menuItem;
        private final Predicate<? super MenuItemActionViewEvent> handled;
        private final Observer<? super MenuItemActionViewEvent> observer;

        Listener(MenuItem menuItem, Predicate<? super MenuItemActionViewEvent> handled, Observer<? super MenuItemActionViewEvent> observer) {
            this.menuItem = menuItem;
            this.handled = handled;
            this.observer = observer;
        }

        public boolean onMenuItemActionExpand(MenuItem item) {
            return this.onEvent(MenuItemActionViewExpandEvent.create(item));
        }

        public boolean onMenuItemActionCollapse(MenuItem item) {
            return this.onEvent(MenuItemActionViewCollapseEvent.create(item));
        }

        private boolean onEvent(MenuItemActionViewEvent event) {
            if (!this.isDisposed()) {
                try {
                    if (this.handled.test((Object)event)) {
                        this.observer.onNext((Object)event);
                        return true;
                    }
                }
                catch (Exception e) {
                    this.observer.onError((Throwable)e);
                    this.dispose();
                }
            }
            return false;
        }

        protected void onDispose() {
            this.menuItem.setOnActionExpandListener(null);
        }
    }
}

