/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.view.View;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.view.ViewLayoutChangeEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class ViewLayoutChangeEventObservable
extends Observable<ViewLayoutChangeEvent> {
    private final View view;

    ViewLayoutChangeEventObservable(View view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super ViewLayoutChangeEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.addOnLayoutChangeListener((View.OnLayoutChangeListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements View.OnLayoutChangeListener {
        private final View view;
        private final Observer<? super ViewLayoutChangeEvent> observer;

        Listener(View view, Observer<? super ViewLayoutChangeEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)ViewLayoutChangeEvent.create(v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom));
            }
        }

        protected void onDispose() {
            this.view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        }
    }
}

