/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.view;

import android.view.View;
import com.jakewharton.rxbinding2.internal.Notification;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.Callable;

final class ViewLongClickObservable
extends Observable<Object> {
    private final View view;
    private final Callable<Boolean> handled;

    ViewLongClickObservable(View view, Callable<Boolean> handled) {
        this.view = view;
        this.handled = handled;
    }

    protected void subscribeActual(Observer<? super Object> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, this.handled, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnLongClickListener((View.OnLongClickListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements View.OnLongClickListener {
        private final View view;
        private final Observer<? super Object> observer;
        private final Callable<Boolean> handled;

        Listener(View view, Callable<Boolean> handled, Observer<? super Object> observer) {
            this.view = view;
            this.observer = observer;
            this.handled = handled;
        }

        public boolean onLongClick(View v) {
            if (!this.isDisposed()) {
                try {
                    if (this.handled.call().booleanValue()) {
                        this.observer.onNext((Object)Notification.INSTANCE);
                        return true;
                    }
                }
                catch (Exception e) {
                    this.observer.onError((Throwable)e);
                    this.dispose();
                }
            }
            return false;
        }

        protected void onDispose() {
            this.view.setOnLongClickListener(null);
        }
    }
}

