/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.widget.AbsListView;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.widget.AbsListViewScrollEvent;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class AbsListViewScrollEventObservable
extends Observable<AbsListViewScrollEvent> {
    private final AbsListView view;

    AbsListViewScrollEventObservable(AbsListView view) {
        this.view = view;
    }

    protected void subscribeActual(Observer<? super AbsListViewScrollEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnScrollListener((AbsListView.OnScrollListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements AbsListView.OnScrollListener {
        private final AbsListView view;
        private final Observer<? super AbsListViewScrollEvent> observer;
        private int currentScrollState = 0;

        Listener(AbsListView view, Observer<? super AbsListViewScrollEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onScrollStateChanged(AbsListView absListView, int scrollState) {
            this.currentScrollState = scrollState;
            if (!this.isDisposed()) {
                AbsListViewScrollEvent event = AbsListViewScrollEvent.create(this.view, scrollState, this.view.getFirstVisiblePosition(), this.view.getChildCount(), this.view.getCount());
                this.observer.onNext((Object)event);
            }
        }

        public void onScroll(AbsListView absListView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (!this.isDisposed()) {
                AbsListViewScrollEvent event = AbsListViewScrollEvent.create(this.view, this.currentScrollState, firstVisibleItem, visibleItemCount, totalItemCount);
                this.observer.onNext((Object)event);
            }
        }

        protected void onDispose() {
            this.view.setOnScrollListener(null);
        }
    }
}

