/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.database.DataSetObserver;
import android.widget.Adapter;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;

final class AdapterDataChangeObservable<T extends Adapter>
extends InitialValueObservable<T> {
    private final T adapter;

    AdapterDataChangeObservable(T adapter) {
        this.adapter = adapter;
    }

    @Override
    protected void subscribeListener(Observer<? super T> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        ObserverDisposable<? super T> disposableDataSetObserver = new ObserverDisposable<T>(this.adapter, observer);
        this.adapter.registerDataSetObserver(disposableDataSetObserver.dataSetObserver);
        observer.onSubscribe(disposableDataSetObserver);
    }

    @Override
    protected T getInitialValue() {
        return this.adapter;
    }

    static final class ObserverDisposable<T extends Adapter>
    extends MainThreadDisposable {
        private final T adapter;
        final DataSetObserver dataSetObserver;

        ObserverDisposable(T adapter, Observer<? super T> observer) {
            this.adapter = adapter;
            this.dataSetObserver = new DataSetObserver((Observer)observer, (Adapter)adapter){
                final /* synthetic */ Observer val$observer;
                final /* synthetic */ Adapter val$adapter;
                {
                    this.val$observer = observer;
                    this.val$adapter = adapter;
                }

                public void onChanged() {
                    if (!ObserverDisposable.this.isDisposed()) {
                        this.val$observer.onNext((Object)this.val$adapter);
                    }
                }
            };
        }

        protected void onDispose() {
            this.adapter.unregisterDataSetObserver(this.dataSetObserver);
        }
    }
}

