/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.view.View;
import android.widget.AdapterView;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.Callable;

final class AdapterViewItemLongClickObservable
extends Observable<Integer> {
    private final AdapterView<?> view;
    private final Callable<Boolean> handled;

    AdapterViewItemLongClickObservable(AdapterView<?> view, Callable<Boolean> handled) {
        this.view = view;
        this.handled = handled;
    }

    protected void subscribeActual(Observer<? super Integer> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer, this.handled);
        observer.onSubscribe((Disposable)listener);
        this.view.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)listener);
    }

    static final class Listener
    extends MainThreadDisposable
    implements AdapterView.OnItemLongClickListener {
        private final AdapterView<?> view;
        private final Observer<? super Integer> observer;
        private final Callable<Boolean> handled;

        Listener(AdapterView<?> view, Observer<? super Integer> observer, Callable<Boolean> handled) {
            this.view = view;
            this.observer = observer;
            this.handled = handled;
        }

        public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
            if (!this.isDisposed()) {
                try {
                    if (this.handled.call().booleanValue()) {
                        this.observer.onNext((Object)position);
                        return true;
                    }
                }
                catch (Exception e) {
                    this.observer.onError((Throwable)e);
                    this.dispose();
                }
            }
            return false;
        }

        protected void onDispose() {
            this.view.setOnItemLongClickListener(null);
        }
    }
}

