/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.view.View;
import android.widget.AdapterView;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.widget.AdapterViewItemSelectionEvent;
import com.jakewharton.rxbinding2.widget.AdapterViewNothingSelectionEvent;
import com.jakewharton.rxbinding2.widget.AdapterViewSelectionEvent;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class AdapterViewSelectionObservable
extends InitialValueObservable<AdapterViewSelectionEvent> {
    private final AdapterView<?> view;

    AdapterViewSelectionObservable(AdapterView<?> view) {
        this.view = view;
    }

    @Override
    protected void subscribeListener(Observer<? super AdapterViewSelectionEvent> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        this.view.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)listener);
        observer.onSubscribe((Disposable)listener);
    }

    @Override
    protected AdapterViewSelectionEvent getInitialValue() {
        int selectedPosition = this.view.getSelectedItemPosition();
        if (selectedPosition == -1) {
            return AdapterViewNothingSelectionEvent.create(this.view);
        }
        View selectedView = this.view.getSelectedView();
        long selectedId = this.view.getSelectedItemId();
        return AdapterViewItemSelectionEvent.create(this.view, selectedView, selectedPosition, selectedId);
    }

    static final class Listener
    extends MainThreadDisposable
    implements AdapterView.OnItemSelectedListener {
        private final AdapterView<?> view;
        private final Observer<? super AdapterViewSelectionEvent> observer;

        Listener(AdapterView<?> view, Observer<? super AdapterViewSelectionEvent> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)AdapterViewItemSelectionEvent.create(parent, view, position, id));
            }
        }

        public void onNothingSelected(AdapterView<?> parent) {
            if (!this.isDisposed()) {
                this.observer.onNext((Object)AdapterViewNothingSelectionEvent.create(parent));
            }
        }

        protected void onDispose() {
            this.view.setOnItemSelectedListener(null);
        }
    }
}

