/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.widget.RadioGroup;
import com.jakewharton.rxbinding2.InitialValueObservable;
import com.jakewharton.rxbinding2.internal.Preconditions;
import io.reactivex.Observer;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

final class RadioGroupCheckedChangeObservable
extends InitialValueObservable<Integer> {
    private final RadioGroup view;

    RadioGroupCheckedChangeObservable(RadioGroup view) {
        this.view = view;
    }

    @Override
    protected void subscribeListener(Observer<? super Integer> observer) {
        if (!Preconditions.checkMainThread(observer)) {
            return;
        }
        Listener listener = new Listener(this.view, observer);
        this.view.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)listener);
        observer.onSubscribe((Disposable)listener);
    }

    @Override
    protected Integer getInitialValue() {
        return this.view.getCheckedRadioButtonId();
    }

    static final class Listener
    extends MainThreadDisposable
    implements RadioGroup.OnCheckedChangeListener {
        private final RadioGroup view;
        private final Observer<? super Integer> observer;
        private int lastChecked = -1;

        Listener(RadioGroup view, Observer<? super Integer> observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onCheckedChanged(RadioGroup radioGroup, int checkedId) {
            if (!this.isDisposed() && checkedId != this.lastChecked) {
                this.lastChecked = checkedId;
                this.observer.onNext((Object)checkedId);
            }
        }

        protected void onDispose() {
            this.view.setOnCheckedChangeListener(null);
        }
    }
}

