/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.widget.AutoCompleteTextView;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.widget.AdapterViewItemClickEvent;
import com.jakewharton.rxbinding2.widget.AutoCompleteTextViewItemClickEventObservable;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;

public final class RxAutoCompleteTextView {
    @CheckResult
    @NonNull
    public static Observable<AdapterViewItemClickEvent> itemClickEvents(@NonNull AutoCompleteTextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return new AutoCompleteTextViewItemClickEventObservable(view);
    }

    @CheckResult
    @NonNull
    public static Consumer<? super CharSequence> completionHint(final @NonNull AutoCompleteTextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return new Consumer<CharSequence>(){

            public void accept(CharSequence completionHint) {
                view.setCompletionHint(completionHint);
            }
        };
    }

    @CheckResult
    @NonNull
    public static Consumer<? super Integer> threshold(final @NonNull AutoCompleteTextView view) {
        Preconditions.checkNotNull(view, "view == null");
        return new Consumer<Integer>(){

            public void accept(Integer threshold) {
                view.setThreshold(threshold.intValue());
            }
        };
    }

    private RxAutoCompleteTextView() {
        throw new AssertionError((Object)"No instances.");
    }
}

