/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.rxbinding2.widget;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.view.MenuItem;
import android.widget.Toolbar;
import com.jakewharton.rxbinding2.internal.Preconditions;
import com.jakewharton.rxbinding2.widget.ToolbarItemClickObservable;
import com.jakewharton.rxbinding2.widget.ToolbarNavigationClickObservable;
import io.reactivex.Observable;
import io.reactivex.functions.Consumer;

@RequiresApi(value=21)
public final class RxToolbar {
    @CheckResult
    @NonNull
    public static Observable<MenuItem> itemClicks(@NonNull Toolbar view) {
        Preconditions.checkNotNull(view, "view == null");
        return new ToolbarItemClickObservable(view);
    }

    @CheckResult
    @NonNull
    public static Observable<Object> navigationClicks(@NonNull Toolbar view) {
        Preconditions.checkNotNull(view, "view == null");
        return new ToolbarNavigationClickObservable(view);
    }

    @CheckResult
    @NonNull
    public static Consumer<? super CharSequence> title(final @NonNull Toolbar view) {
        Preconditions.checkNotNull(view, "view == null");
        return new Consumer<CharSequence>(){

            public void accept(CharSequence title) {
                view.setTitle(title);
            }
        };
    }

    @CheckResult
    @NonNull
    public static Consumer<? super Integer> titleRes(final @NonNull Toolbar view) {
        Preconditions.checkNotNull(view, "view == null");
        return new Consumer<Integer>(){

            public void accept(Integer titleRes) {
                view.setTitle(titleRes.intValue());
            }
        };
    }

    @CheckResult
    @NonNull
    public static Consumer<? super CharSequence> subtitle(final @NonNull Toolbar view) {
        Preconditions.checkNotNull(view, "view == null");
        return new Consumer<CharSequence>(){

            public void accept(CharSequence subtitle) {
                view.setSubtitle(subtitle);
            }
        };
    }

    @CheckResult
    @NonNull
    public static Consumer<? super Integer> subtitleRes(final @NonNull Toolbar view) {
        Preconditions.checkNotNull(view, "view == null");
        return new Consumer<Integer>(){

            public void accept(Integer subtitleRes) {
                view.setSubtitle(subtitleRes.intValue());
            }
        };
    }

    private RxToolbar() {
        throw new AssertionError((Object)"No instances.");
    }
}

