/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.formatter;

public enum LineEnding {
    AUTO(System.getProperty("line.separator")),
    KEEP(null),
    LF("\n"),
    CRLF("\r\n"),
    CR("\r"),
    UNKNOW(null);

    private final String chars;

    private LineEnding(String chars) {
        this.chars = chars;
    }

    public String getChars() {
        return this.chars;
    }

    public static LineEnding determineLineEnding(String fileDataString) {
        int lfCount = 0;
        int crCount = 0;
        int crlfCount = 0;
        int i = 0;
        while (i < fileDataString.length()) {
            char c = fileDataString.charAt(i);
            if (c == '\r') {
                if (i + 1 < fileDataString.length() && fileDataString.charAt(i + 1) == '\n') {
                    ++crlfCount;
                    ++i;
                } else {
                    ++crCount;
                }
            } else if (c == '\n') {
                ++lfCount;
            }
            ++i;
        }
        if (lfCount > crCount && lfCount > crlfCount) {
            return LF;
        }
        if (crlfCount > lfCount && crlfCount > crCount) {
            return CRLF;
        }
        if (crCount > lfCount && crCount > crlfCount) {
            return CR;
        }
        return UNKNOW;
    }

    public String fix(String text) {
        if (this == KEEP) {
            return text;
        }
        LineEnding current = LineEnding.determineLineEnding(text);
        if (current == UNKNOW) {
            return text.replaceAll("(\\r\\n)|(\\n)|(\\r)", this.getChars());
        }
        if (this == current) {
            return text;
        }
        return text.replace(current.getChars(), this.getChars());
    }
}

