/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext;

import com.mayabot.nlp.fasttext.Meter;
import com.mayabot.nlp.fasttext.ScoreIdPair;
import com.mayabot.nlp.fasttext.dictionary.Dictionary;
import com.mayabot.nlp.fasttext.utils.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001+B?\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012$\b\u0002\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003`\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bJ\u001c\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u0006\u0010\u001f\u001a\u00020\u0016J\u000e\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bJ \u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\b2\b\b\u0002\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020\u0016J\u000e\u0010&\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020\bJ.\u0010)\u001a\u00020\u0003*\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003`\t2\u0006\u0010*\u001a\u00020\bR6\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0003`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006,"}, d2={"Lcom/mayabot/nlp/fasttext/Meter;", "", "metrics", "Lcom/mayabot/nlp/fasttext/Meter$Metrics;", "nexamples", "", "labelMetrics", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "(Lcom/mayabot/nlp/fasttext/Meter$Metrics;JLjava/util/HashMap;)V", "getLabelMetrics", "()Ljava/util/HashMap;", "setLabelMetrics", "(Ljava/util/HashMap;)V", "getMetrics", "()Lcom/mayabot/nlp/fasttext/Meter$Metrics;", "getNexamples", "()J", "setNexamples", "(J)V", "f1Score", "", "i", "log", "", "labels", "Lcom/mayabot/nlp/fasttext/utils/IntArrayList;", "predictions", "", "Lcom/mayabot/nlp/fasttext/ScoreIdPair;", "precision", "print", "dict", "Lcom/mayabot/nlp/fasttext/dictionary/Dictionary;", "k", "perLabel", "", "recall", "writeGeneralMetrics", "", "find", "key", "Metrics", "fastText4j"})
public final class Meter {
    @NotNull
    private final Metrics metrics;
    private long nexamples;
    @NotNull
    private HashMap<Integer, Metrics> labelMetrics;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Metrics find(@NotNull HashMap<Integer, Metrics> $this$find, int key) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkParameterIsNotNull($this$find, (String)"$this$find");
        Map map = $this$find;
        Integer key$iv = key;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Metrics answer$iv = new Metrics(0L, 0L, 0L, 7, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Metrics)object;
    }

    public final void log(@NotNull IntArrayList labels, @NotNull List<ScoreIdPair> predictions) {
        Intrinsics.checkParameterIsNotNull((Object)labels, (String)"labels");
        Intrinsics.checkParameterIsNotNull(predictions, (String)"predictions");
        long l = this.nexamples;
        this.nexamples = l + 1L;
        Metrics metrics = this.metrics;
        metrics.setGold(metrics.getGold() + (long)labels.size());
        Metrics metrics2 = this.metrics;
        metrics2.setPredicted(metrics2.getPredicted() + (long)predictions.size());
        for (ScoreIdPair prediction : predictions) {
            Metrics metrics3 = this.find(this.labelMetrics, prediction.getId());
            long l2 = metrics3.getPredicted();
            metrics3.setPredicted(l2 + 1L);
            float f = prediction.getScore();
            boolean bl = false;
            double score = (float)Math.exp(f);
            double gold = 0.0;
            if (labels.contains(prediction.getId())) {
                Metrics metrics4 = this.find(this.labelMetrics, prediction.getId());
                long l3 = metrics4.getPredictedGold();
                metrics4.setPredictedGold(l3 + 1L);
                Metrics metrics5 = this.metrics;
                l3 = metrics5.getPredictedGold();
                metrics5.setPredictedGold(l3 + 1L);
                gold = 1.0;
            }
            this.find(this.labelMetrics, prediction.getId()).getScoreVsTrue().add((Pair<Double, Double>)TuplesKt.to((Object)score, (Object)gold));
        }
        IntArrayList this_$iv = labels;
        boolean $i$f$forEach = false;
        int[] buffer$iv = this_$iv.getBuffer();
        int size$iv = this_$iv.size();
        for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
            int label = buffer$iv[i$iv];
            boolean bl = false;
            Metrics metrics6 = this.find(this.labelMetrics, label);
            long l4 = metrics6.getGold();
            metrics6.setGold(l4 + 1L);
        }
    }

    public final double precision(int i) {
        return this.find(this.labelMetrics, i).precision();
    }

    public final double recall(int i) {
        return this.find(this.labelMetrics, i).recall();
    }

    public final double f1Score(int i) {
        return this.find(this.labelMetrics, i).f1Score();
    }

    public final double precision() {
        return this.metrics.precision();
    }

    public final double recall() {
        return this.metrics.recall();
    }

    public final double f1Score() {
        double recall;
        double precision = this.precision();
        if (precision + (recall = this.recall()) != 0.0) {
            return (double)2 * precision * recall / (precision + recall);
        }
        return DoubleCompanionObject.INSTANCE.getNaN();
    }

    @NotNull
    public final String writeGeneralMetrics(int k) {
        StringBuilder sb = new StringBuilder();
        sb.append("N\t" + this.nexamples + '\n');
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%.3f";
        Object[] objectArray = new Object[]{this.metrics.precision()};
        StringBuilder stringBuilder = new StringBuilder().append("P@").append(k).append('\t');
        StringBuilder stringBuilder2 = sb;
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String string3 = string2;
        stringBuilder2.append(stringBuilder.append(string3).append('\n').toString());
        stringCompanionObject = StringCompanionObject.INSTANCE;
        string = "%.3f";
        objectArray = new Object[]{this.metrics.recall()};
        stringBuilder = new StringBuilder().append("R@").append(k).append('\t');
        stringBuilder2 = sb;
        bl = false;
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
        string3 = string4;
        stringBuilder2.append(stringBuilder.append(string3).append('\n').toString());
        String string5 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"sb.toString()");
        return string5;
    }

    /*
     * WARNING - void declaration
     */
    public final void print(@NotNull Dictionary dict, int k, boolean perLabel) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)dict, (String)"dict");
        if (perLabel) {
            print.1 $fun$writeMetric$1 = print.1.INSTANCE;
            n = 0;
            int n2 = dict.getNlabels();
            while (n < n2) {
                void labelId;
                $fun$writeMetric$1.invoke("F1-Score", this.f1Score((int)labelId));
                $fun$writeMetric$1.invoke("Precision", this.precision((int)labelId));
                $fun$writeMetric$1.invoke("Recall", this.recall((int)labelId));
                String string = ' ' + dict.getLabel((int)labelId);
                boolean bl = false;
                System.out.println((Object)string);
                ++labelId;
            }
        }
        String string = this.writeGeneralMetrics(k);
        n = 0;
        System.out.println((Object)string);
    }

    public static /* synthetic */ void print$default(Meter meter, Dictionary dictionary, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        meter.print(dictionary, n, bl);
    }

    @NotNull
    public final Metrics getMetrics() {
        return this.metrics;
    }

    public final long getNexamples() {
        return this.nexamples;
    }

    public final void setNexamples(long l) {
        this.nexamples = l;
    }

    @NotNull
    public final HashMap<Integer, Metrics> getLabelMetrics() {
        return this.labelMetrics;
    }

    public final void setLabelMetrics(@NotNull HashMap<Integer, Metrics> hashMap) {
        Intrinsics.checkParameterIsNotNull(hashMap, (String)"<set-?>");
        this.labelMetrics = hashMap;
    }

    public Meter(@NotNull Metrics metrics, long nexamples, @NotNull HashMap<Integer, Metrics> labelMetrics) {
        Intrinsics.checkParameterIsNotNull((Object)metrics, (String)"metrics");
        Intrinsics.checkParameterIsNotNull(labelMetrics, (String)"labelMetrics");
        this.metrics = metrics;
        this.nexamples = nexamples;
        this.labelMetrics = labelMetrics;
    }

    public /* synthetic */ Meter(Metrics metrics, long l, HashMap hashMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            metrics = new Metrics(0L, 0L, 0L, 7, null);
        }
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            hashMap = new HashMap<Integer, Metrics>();
        }
        this(metrics, l, hashMap);
    }

    public Meter() {
        this(null, 0L, null, 7, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0017\u001a\u00020\u0012J\u0006\u0010\u0018\u001a\u00020\u0012J\u0006\u0010\u0019\u001a\u00020\u0012R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\nR,\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lcom/mayabot/nlp/fasttext/Meter$Metrics;", "", "gold", "", "predicted", "predictedGold", "(JJJ)V", "getGold", "()J", "setGold", "(J)V", "getPredicted", "setPredicted", "getPredictedGold", "setPredictedGold", "scoreVsTrue", "", "Lkotlin/Pair;", "", "getScoreVsTrue", "()Ljava/util/List;", "setScoreVsTrue", "(Ljava/util/List;)V", "f1Score", "precision", "recall", "fastText4j"})
    public static final class Metrics {
        @NotNull
        private List<Pair<Double, Double>> scoreVsTrue;
        private long gold;
        private long predicted;
        private long predictedGold;

        @NotNull
        public final List<Pair<Double, Double>> getScoreVsTrue() {
            return this.scoreVsTrue;
        }

        public final void setScoreVsTrue(@NotNull List<Pair<Double, Double>> list) {
            Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
            this.scoreVsTrue = list;
        }

        public final double precision() {
            if (this.predicted == 0L) {
                return DoubleCompanionObject.INSTANCE.getNaN();
            }
            return (double)this.predictedGold / (double)this.predicted;
        }

        public final double recall() {
            if (this.gold == 0L) {
                return DoubleCompanionObject.INSTANCE.getNaN();
            }
            return (double)this.predictedGold / (double)this.gold;
        }

        public final double f1Score() {
            if (this.predicted + this.gold == 0L) {
                return DoubleCompanionObject.INSTANCE.getNaN();
            }
            return (double)((long)2 * this.predictedGold) / (double)(this.predicted + this.gold);
        }

        public final long getGold() {
            return this.gold;
        }

        public final void setGold(long l) {
            this.gold = l;
        }

        public final long getPredicted() {
            return this.predicted;
        }

        public final void setPredicted(long l) {
            this.predicted = l;
        }

        public final long getPredictedGold() {
            return this.predictedGold;
        }

        public final void setPredictedGold(long l) {
            this.predictedGold = l;
        }

        public Metrics(long gold, long predicted, long predictedGold) {
            List list;
            this.gold = gold;
            this.predicted = predicted;
            this.predictedGold = predictedGold;
            Metrics metrics = this;
            boolean bl = false;
            metrics.scoreVsTrue = list = (List)new ArrayList();
        }

        public /* synthetic */ Metrics(long l, long l2, long l3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 0L;
            }
            if ((n & 2) != 0) {
                l2 = 0L;
            }
            if ((n & 4) != 0) {
                l3 = 0L;
            }
            this(l, l2, l3);
        }

        public Metrics() {
            this(0L, 0L, 0L, 7, null);
        }
    }
}

