/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.autotune;

import com.mayabot.nlp.fasttext.args.Args;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018J8\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010 \u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJH\u0010\"\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0003R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/mayabot/nlp/fasttext/autotune/AutotuneStrategy;", "", "originalArgs", "Lcom/mayabot/nlp/fasttext/args/Args;", "seed", "", "(Lcom/mayabot/nlp/fasttext/args/Args;J)V", "bestArg", "bestDsubExponent", "", "bestMinnIndex", "bestNonzeroBucket", "maxDuration", "minnChoices", "", "getMinnChoices", "()Ljava/util/List;", "setMinnChoices", "(Ljava/util/List;)V", "rng", "Ljava/util/Random;", "trials", "ask", "elapsed", "", "getArgGauss", "value", "startSigma", "endSigma", "t", "linear", "", "getIndex", "choices", "updateArgGauss", "min", "max", "liner", "updateBest", "", "args", "fastText4j"})
public final class AutotuneStrategy {
    private Args bestArg;
    private int maxDuration;
    private final Random rng;
    private int trials;
    private int bestMinnIndex;
    private int bestDsubExponent;
    private int bestNonzeroBucket;
    @NotNull
    private List<Integer> minnChoices;

    @NotNull
    public final List<Integer> getMinnChoices() {
        return this.minnChoices;
    }

    public final void setMinnChoices(@NotNull List<Integer> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.minnChoices = list;
    }

    @NotNull
    public final Args ask(double elapsed) {
        float f = 1.0f;
        float f2 = (float)(elapsed / (double)this.maxDuration);
        boolean bl = false;
        double t = Math.min(f, f2);
        int n = this.trials;
        this.trials = n + 1;
        if (this.trials == 1) {
            return this.bestArg;
        }
        Args args = this.bestArg;
        if (!args.isManual("epoch")) {
            args = Args.copy$default(args, 0, 0, 0, 0, 0, 0, 0.0, 0, 0, 0, (int)this.updateArgGauss(args.getEpoch(), 1.0, 100.0, 2.8, 2.5, t, false, this.rng), 0, null, null, 0, 0, 0, null, 0.0, null, null, null, 0, 0, null, 0x1FFFBFF, null);
        }
        if (!args.isManual("lr")) {
            args = Args.copy$default(args, 0, 0, 0, 0, 0, 0, 0.0, 0, 0, 0, 0, 0, null, null, 0, 0, 0, null, this.updateArgGauss(args.getLr(), 0.01, 5.0, 1.9, 1.0, t, false, this.rng), null, null, null, 0, 0, null, 0x1FBFFFF, null);
        }
        if (!args.isManual("dim")) {
            args = Args.copy$default(args, 0, 0, 0, 0, 0, 0, 0.0, 0, (int)this.updateArgGauss(args.getDim(), 1.0, 1000.0, 1.4, 0.3, t, false, this.rng), 0, 0, 0, null, null, 0, 0, 0, null, 0.0, null, null, null, 0, 0, null, 0x1FFFEFF, null);
        }
        boolean bl2 = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    private final double updateArgGauss(double value, double min, double max, double startSigma, double endSigma, double t, boolean liner, Random rng) {
        double retVal = this.getArgGauss(value, rng, startSigma, endSigma, t, liner);
        if (retVal > max) {
            retVal = max;
        }
        if (retVal < min) {
            retVal = min;
        }
        return retVal;
    }

    private final double getArgGauss(double value, Random rng, double startSigma, double endSigma, double t, boolean linear) {
        double d;
        double d2;
        double d3 = 0.5;
        double d4 = t - 0.25;
        double d5 = 0.0;
        double d6 = (startSigma - endSigma) / 0.5;
        double d7 = startSigma;
        boolean bl = false;
        d4 = d2 = Math.max(d4, d5);
        boolean bl2 = false;
        d2 = Math.min(d3, d4);
        double stddev = d7 - d6 * d2;
        Function0 normal2 = (Function0)new Function0<Double>(rng, stddev){
            final /* synthetic */ Random $rng;
            final /* synthetic */ double $stddev;

            public final double invoke() {
                return this.$rng.nextGaussian() * this.$stddev;
            }
            {
                this.$rng = random;
                this.$stddev = d;
                super(0);
            }
        };
        double coeff = ((Number)normal2.invoke()).doubleValue();
        if (linear) {
            d = coeff + value;
        } else {
            double d8 = 2.0;
            boolean bl3 = false;
            d = Math.pow(d8, coeff) * value;
        }
        return d;
    }

    public final int getIndex(int value, @NotNull List<Integer> choices) {
        Intrinsics.checkParameterIsNotNull(choices, (String)"choices");
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    public final void updateBest(@NotNull Args args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
    }

    public AutotuneStrategy(@NotNull Args originalArgs, long seed) {
        Intrinsics.checkParameterIsNotNull((Object)originalArgs, (String)"originalArgs");
        this.bestArg = new Args(0, 0, 0, 0, 0, 0, 0.0, 0, 0, 0, 0, 0, null, null, 0, 0, 0, null, 0.0, null, null, null, 0, 0, null, 0x1FFFFFF, null);
        this.maxDuration = originalArgs.getAutotuneDuration();
        this.rng = new Random(seed);
        this.bestDsubExponent = 1;
        this.bestNonzeroBucket = 2000000;
        this.minnChoices = CollectionsKt.listOf((Object[])new Integer[]{0, 2, 3});
        this.updateBest(originalArgs);
    }
}

