/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.blas;

import com.mayabot.nlp.fasttext.blas.BasicDenseMatrix;
import com.mayabot.nlp.fasttext.blas.DenseVector;
import com.mayabot.nlp.fasttext.blas.Vector;
import com.mayabot.nlp.fasttext.utils.IOUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0004H\u0096\u0002J\u0019\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0096\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J!\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0017H\u0096\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\"\u001a\u00020\u0012H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/mayabot/nlp/fasttext/blas/DenseArrayMatrix;", "Lcom/mayabot/nlp/fasttext/blas/BasicDenseMatrix;", "()V", "rows", "", "cols", "(II)V", "row", "col", "data", "", "(II[F)V", "getData", "()[F", "length", "rnd", "Ljava/util/Random;", "gaussRandom", "", "number", "", "get", "Lcom/mayabot/nlp/fasttext/blas/Vector;", "", "i", "j", "save", "file", "Ljava/io/File;", "channel", "Ljava/nio/channels/FileChannel;", "set", "v", "uniform", "zero", "fastText4j"})
public final class DenseArrayMatrix
extends BasicDenseMatrix {
    private final int length;
    private final Random rnd;
    @NotNull
    private final float[] data;

    /*
     * WARNING - void declaration
     */
    @Override
    public void zero() {
        int n = 0;
        int n2 = this.length;
        while (n < n2) {
            void i;
            this.data[i] = 0.0f;
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void uniform(@NotNull Number number) {
        Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
        float a = number.floatValue();
        float lower = -a;
        int n = 0;
        int n2 = this.length;
        while (n < n2) {
            void i;
            this.data[i] = this.rnd.nextFloat() * (a - lower) + lower;
            ++i;
        }
    }

    @Override
    public void save(@NotNull FileChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Function1<FileChannel, Unit> $fun$write$1 = new Function1<FileChannel, Unit>(this){
            final /* synthetic */ DenseArrayMatrix this$0;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull FileChannel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.this$0.getCol() * 4);
                FloatBuffer asFloatBuffer = byteBuffer.asFloatBuffer();
                int n = 0;
                int n2 = this.this$0.getRow();
                while (n < n2) {
                    void row;
                    asFloatBuffer.clear();
                    asFloatBuffer.put(this.this$0.getData(), (int)(row * this.this$0.getCol()), this.this$0.getCol());
                    byteBuffer.position(0);
                    byteBuffer.limit(this.this$0.getCol() * 4);
                    channel.write(byteBuffer);
                    ++row;
                }
            }
            {
                this.this$0 = denseArrayMatrix;
                super(1);
            }
        };
        IOUtilsKt.writeInt(channel, this.getRow());
        IOUtilsKt.writeInt(channel, this.getCol());
        $fun$write$1.invoke(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Object object = file;
        boolean bl = false;
        object = new FileOutputStream((File)object).getChannel();
        bl = false;
        Throwable throwable = null;
        try {
            FileChannel channel = (FileChannel)object;
            boolean bl2 = false;
            FileChannel fileChannel = channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileChannel, (String)"channel");
            this.save(fileChannel);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void gaussRandom(@NotNull Number number) {
        Intrinsics.checkParameterIsNotNull((Object)number, (String)"number");
        float sd = number.floatValue();
        int n = 0;
        int n2 = this.length;
        while (n < n2) {
            void i;
            this.data[i] = (float)(this.rnd.nextGaussian() * (double)sd);
            ++i;
        }
    }

    @Override
    @NotNull
    public Vector get(int row) {
        return new DenseVector(this.data, row * this.getCol(), this.getCol());
    }

    @Override
    public float get(int i, int j) {
        return this.data[i * this.getCol() + j];
    }

    @Override
    public void set(int i, int j, float v) {
        this.data[i * this.getCol() + j] = v;
    }

    @NotNull
    public final float[] getData() {
        return this.data;
    }

    public DenseArrayMatrix(int row, int col, @NotNull float[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super(row, col);
        this.data = data;
        this.length = row * col;
        this.rnd = new Random(0L);
    }

    public DenseArrayMatrix() {
        this(0, 0);
    }

    public DenseArrayMatrix(int rows, int cols) {
        this(rows, cols, new float[rows * cols]);
    }
}

