/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.fasttext.blas;

import com.mayabot.nlp.fasttext.blas.AreaByteBufferMatrix;
import com.mayabot.nlp.fasttext.blas.BlasUtilsKt;
import com.mayabot.nlp.fasttext.blas.DenseArrayMatrix;
import com.mayabot.nlp.fasttext.blas.DenseArrayMatrixKt;
import com.mayabot.nlp.fasttext.blas.DenseMatrix;
import com.mayabot.nlp.fasttext.utils.AutoDataInput;
import com.mayabot.nlp.fasttext.utils.IOUtilsKt;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\r"}, d2={"loadDenseMatrix", "Lcom/mayabot/nlp/fasttext/blas/DenseMatrix;", "dataInput", "Lcom/mayabot/nlp/fasttext/utils/AutoDataInput;", "file", "Ljava/io/File;", "mmap", "", "inputStream", "Ljava/io/InputStream;", "loadFloatArrayMatrix", "Lcom/mayabot/nlp/fasttext/blas/DenseArrayMatrix;", "loadFloatArrayMatrixCPP", "fastText4j"})
public final class DenseArrayMatrixKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DenseMatrix loadDenseMatrix(@NotNull AutoDataInput dataInput) {
        Intrinsics.checkParameterIsNotNull((Object)dataInput, (String)"dataInput");
        int rows = dataInput.readInt();
        int cols = dataInput.readInt();
        float[] floatArray = new float[rows * cols];
        int n = 0;
        int n2 = rows * cols;
        while (n < n2) {
            void i;
            floatArray[i] = dataInput.readFloat();
            ++i;
        }
        return BlasUtilsKt.floatArrayMatrix(rows, cols, floatArray);
    }

    @NotNull
    public static final DenseMatrix loadDenseMatrix(@Nullable InputStream inputStream) {
        AutoDataInput dataInput = new AutoDataInput(new DataInputStream(inputStream), null, 2, null);
        return DenseArrayMatrixKt.loadDenseMatrix(dataInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final DenseMatrix loadDenseMatrix(@NotNull File file, boolean mmap) {
        DenseMatrix denseMatrix;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        loadDenseMatrix.1 $fun$pages$1 = loadDenseMatrix.1.INSTANCE;
        if (mmap) {
            Object object = file;
            boolean bl = false;
            object = new FileInputStream((File)object).getChannel();
            bl = false;
            Throwable throwable = null;
            try {
                Object it = (FileChannel)object;
                boolean bl2 = false;
                FileChannel fileChannel = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileChannel, (String)"it");
                int rows = IOUtilsKt.readInt(fileChannel);
                int cols = IOUtilsKt.readInt((FileChannel)it);
                int areaRows = 0;
                while (areaRows * cols < 0x10000000) {
                    areaRows += 10;
                }
                long fileSize = ((FileChannel)it).size();
                long arrayBytes = fileSize - (long)8;
                int areaCount = loadDenseMatrix.1.INSTANCE.invoke(arrayBytes, 4 * areaRows * cols);
                int areaBytes = areaRows * cols * 4;
                long lastBytes = arrayBytes % (long)(areaRows * cols * 4);
                ArrayList list = new ArrayList();
                int n = 0;
                int n2 = areaCount;
                while (n < n2) {
                    void a;
                    long len = a == areaCount - 1 ? lastBytes : (long)areaBytes;
                    Collection collection = list;
                    MappedByteBuffer mappedByteBuffer = ((FileChannel)it).map(FileChannel.MapMode.READ_ONLY, (long)8 + (long)a * (long)areaBytes, len);
                    boolean bl3 = false;
                    collection.add(mappedByteBuffer);
                    ++a;
                }
                it = new AreaByteBufferMatrix(rows, cols, list);
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            denseMatrix = (DenseMatrix)it;
        } else {
            AutoDataInput dataInput = AutoDataInput.Companion.open(file);
            int rows = dataInput.readInt();
            int cols = dataInput.readInt();
            float[] floatArray = new float[rows * cols];
            int bl2 = 0;
            int n = rows * cols;
            while (bl2 < n) {
                void i;
                floatArray[i] = dataInput.readFloat();
                ++i;
            }
            denseMatrix = BlasUtilsKt.floatArrayMatrix(rows, cols, floatArray);
        }
        return denseMatrix;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DenseArrayMatrix loadFloatArrayMatrix(@NotNull AutoDataInput dataInput) {
        Intrinsics.checkParameterIsNotNull((Object)dataInput, (String)"dataInput");
        int rows = dataInput.readInt();
        int cols = dataInput.readInt();
        float[] floatArray = new float[rows * cols];
        int n = 0;
        int n2 = rows * cols;
        while (n < n2) {
            void i;
            floatArray[i] = dataInput.readFloat();
            ++i;
        }
        return BlasUtilsKt.floatArrayMatrix(rows, cols, floatArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DenseArrayMatrix loadFloatArrayMatrixCPP(@NotNull AutoDataInput dataInput) {
        Intrinsics.checkParameterIsNotNull((Object)dataInput, (String)"dataInput");
        int rows = (int)dataInput.readLong();
        int cols = (int)dataInput.readLong();
        float[] floatArray = new float[rows * cols];
        int n = 0;
        int n2 = rows * cols;
        while (n < n2) {
            void i;
            floatArray[i] = dataInput.readFloat();
            ++i;
        }
        return BlasUtilsKt.floatArrayMatrix(rows, cols, floatArray);
    }
}

