/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.collection.dat;

import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class DoubleArrayMaker {
    static InternalLogger logger = InternalLoggerFactory.getInstance(DoubleArrayMaker.class);
    static final int default_capacity = 0x100000;
    static final int leastAddSize = 0x100000;
    private int array_capacity;
    private int[] check;
    private int[] base;
    protected int size;
    private BitSet used;
    private List<String> data;
    private int dataSize;
    private int progress = 0;
    private int nextCheckPos;
    private int error_;

    public DoubleArrayMaker(List<String> key) {
        this(key, 0x100000);
    }

    public DoubleArrayMaker(List<String> key, int initCapacity) {
        this.array_capacity = initCapacity;
        this.check = new int[initCapacity];
        this.base = new int[initCapacity];
        this.used = new BitSet(initCapacity);
        this.data = key;
        this.dataSize = key.size();
        this.progress = 0;
        this.base[0] = 1;
        this.nextCheckPos = 0;
    }

    public int[] getCheck() {
        return this.check;
    }

    public int[] getBase() {
        return this.base;
    }

    public void build() {
        Node root_node = new Node();
        root_node.left = 0;
        root_node.right = this.dataSize;
        root_node.depth = 0;
        ArrayList<Node> siblings = new ArrayList<Node>();
        this.fetch(root_node, siblings);
        long t1 = System.currentTimeMillis();
        this.insert(siblings);
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 200L) {
            logger.info("DAT double array build use time " + (t2 - t1) + " ms");
        }
        this.used = null;
        this.data = null;
        for (int i = this.size; i < this.array_capacity; ++i) {
            if (this.check[i] == 0) continue;
            System.out.println(i);
        }
        this.base = Arrays.copyOfRange(this.base, 0, this.size + 65536);
        this.check = Arrays.copyOfRange(this.check, 0, this.size + 65536);
    }

    private int insert(List<Node> siblings) {
        if (this.error_ < 0) {
            return 0;
        }
        int begin = 0;
        int pos = Math.max(siblings.get((int)0).code + 1, this.nextCheckPos) - 1;
        int nonzero_num = 0;
        boolean first = false;
        if (this.array_capacity <= pos) {
            this.resize(pos + 1);
        }
        int firstSiblingCode = siblings.get((int)0).code;
        int lastSiblingCode = siblings.get((int)(siblings.size() - 1)).code;
        int lastSiblingCodeAndMax = lastSiblingCode + 65535;
        int siblingsSize = siblings.size();
        block0: while (true) {
            int nsize;
            int posPlus = ++pos;
            if (this.array_capacity <= pos && posPlus > this.array_capacity) {
                this.resize(posPlus);
            }
            if (this.check[pos] != 0) {
                ++nonzero_num;
                continue;
            }
            if (!first) {
                this.nextCheckPos = pos;
                first = true;
            }
            if (this.array_capacity <= (begin = pos - firstSiblingCode) + lastSiblingCode && (nsize = begin + lastSiblingCodeAndMax) > this.array_capacity) {
                this.resize(nsize);
            }
            if (this.used.get(begin)) continue;
            for (int i = 1; i < siblingsSize; ++i) {
                if (this.check[begin + siblings.get((int)i).code] == 0) continue;
                continue block0;
            }
            break;
        }
        if (1.0 * (double)nonzero_num / (double)(pos - this.nextCheckPos + 1) >= 0.95) {
            this.nextCheckPos = pos;
        }
        this.used.set(begin);
        this.size = Math.max(this.size, begin + lastSiblingCode + 1);
        for (Node s : siblings) {
            this.check[begin + s.code] = begin;
        }
        for (int i = 0; i < siblings.size(); ++i) {
            int h;
            ArrayList<Node> new_siblings;
            Node theSib = siblings.get(i);
            int x = this.fetch(theSib, new_siblings = new ArrayList<Node>());
            if (x == 0) {
                this.base[begin + theSib.code] = -theSib.left - 1;
                ++this.progress;
                if (this.progress <= 400000 || this.progress % 200000 != 0) continue;
                logger.info("Dat building " + String.format("%.2f", Float.valueOf((float)this.progress * 100.0f / (float)this.dataSize)) + "%");
                continue;
            }
            this.base[begin + theSib.code] = h = this.insert(new_siblings);
        }
        return begin;
    }

    private int fetch(Node parent, List<Node> siblings) {
        if (this.error_ < 0) {
            return 0;
        }
        int prev = 0;
        for (int i = parent.left; i < parent.right; ++i) {
            String tmp = this.data.get(i);
            if (tmp.length() < parent.depth) continue;
            int cur = 0;
            if (tmp.length() != parent.depth) {
                cur = tmp.charAt(parent.depth) + '\u0001';
            }
            if (prev > cur) {
                this.error_ = -3;
                return 0;
            }
            if (cur != prev || siblings.size() == 0) {
                Node tmp_node = new Node();
                tmp_node.depth = parent.depth + 1;
                tmp_node.code = cur;
                tmp_node.left = i;
                if (siblings.size() != 0) {
                    siblings.get((int)(siblings.size() - 1)).right = i;
                }
                siblings.add(tmp_node);
            }
            prev = cur;
        }
        if (siblings.size() != 0) {
            siblings.get((int)(siblings.size() - 1)).right = parent.right;
        }
        return siblings.size();
    }

    private void resize(int new_capacity) {
        if (new_capacity <= this.array_capacity) {
            return;
        }
        new_capacity = Math.max(new_capacity, this.array_capacity + 0x100000);
        this.base = Arrays.copyOf(this.base, new_capacity);
        this.check = Arrays.copyOf(this.check, new_capacity);
        this.array_capacity = new_capacity;
    }

    static int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : n + 1;
    }

    private static class Node {
        int code;
        int depth;
        int left;
        int right;

        private Node() {
        }

        public String toString() {
            return "Node{code=" + this.code + ", depth=" + this.depth + ", left=" + this.left + ", right=" + this.right + '}';
        }
    }
}

