/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.common;

import com.mayabot.nlp.common.ParagraphReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class BufferedReaderLFCR
implements Closeable,
ParagraphReader {
    private Reader in;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private static int defaultCharBufferSize = 8192;
    private static int defaultExpectedLineLength = 80;

    public BufferedReaderLFCR(Reader in, int sz) {
        if (sz <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.in = in;
        this.cb = new char[sz];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public BufferedReaderLFCR(Reader in) {
        this(in, defaultCharBufferSize);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fill() throws IOException {
        int n;
        int dst;
        if (this.markedChar <= -1) {
            dst = 0;
        } else {
            int delta = this.nextChar - this.markedChar;
            if (delta >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                dst = 0;
            } else {
                if (this.readAheadLimit <= this.cb.length) {
                    System.arraycopy(this.cb, this.markedChar, this.cb, 0, delta);
                    this.markedChar = 0;
                    dst = delta;
                } else {
                    char[] ncb = new char[this.readAheadLimit];
                    System.arraycopy(this.cb, this.markedChar, ncb, 0, delta);
                    this.cb = ncb;
                    this.markedChar = 0;
                    dst = delta;
                }
                this.nextChar = this.nChars = delta;
            }
        }
        while ((n = this.in.read(this.cb, dst, this.cb.length - dst)) == 0) {
        }
        if (n > 0) {
            this.nChars = dst + n;
            this.nextChar = dst;
        }
    }

    public String readLine(boolean ignoreLF) throws IOException {
        StringBuffer s = null;
        this.ensureOpen();
        while (true) {
            int i;
            if (this.nextChar >= this.nChars) {
                this.fill();
            }
            if (this.nextChar >= this.nChars) {
                if (s != null && s.length() > 0) {
                    return s.toString();
                }
                return null;
            }
            boolean eol = false;
            char c = '\u0000';
            for (i = this.nextChar; i < this.nChars; ++i) {
                c = this.cb[i];
                if (c != '\n' && c != '\r' && c != '\u3002') continue;
                eol = true;
                break;
            }
            int startChar = this.nextChar;
            this.nextChar = i;
            if (eol) {
                String str;
                if (s == null) {
                    str = new String(this.cb, startChar, i - startChar + 1);
                } else {
                    s.append(this.cb, startChar, i - startChar + 1);
                    str = s.toString();
                }
                ++this.nextChar;
                return str;
            }
            if (s == null) {
                s = new StringBuffer(defaultExpectedLineLength);
            }
            s.append(this.cb, startChar, i - startChar);
        }
    }

    public String readLine() throws IOException {
        return this.readLine(false);
    }

    @Override
    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        try {
            this.in.close();
        }
        finally {
            this.in = null;
            this.cb = null;
        }
    }

    public Stream<String> lines() {
        Iterator<String> iter = new Iterator<String>(){
            String nextLine = null;

            @Override
            public boolean hasNext() {
                if (this.nextLine != null) {
                    return true;
                }
                try {
                    this.nextLine = BufferedReaderLFCR.this.readLine();
                    return this.nextLine != null;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public String next() {
                if (this.nextLine != null || this.hasNext()) {
                    String line = this.nextLine;
                    this.nextLine = null;
                    return line;
                }
                throw new NoSuchElementException();
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 272), false);
    }

    @Override
    public String next() throws IOException {
        return this.readLine();
    }
}

