/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.utils;

import com.mayabot.nlp.utils.MyInts;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;

public interface DataInOutputUtils {
    public static final int[] nullMagic = new int[]{1123992342, 832718121, 957462342};

    public static void writeIntArray(int[][] array, DataOutput output) throws IOException {
        int line = array.length;
        output.writeInt(line);
        for (int i = 0; i < line; ++i) {
            DataInOutputUtils.writeIntArray(array[i], output);
        }
    }

    public static int[][] readDoubleIntArray(DataInput input) throws IOException {
        int line = input.readInt();
        int[][] result = new int[line][];
        for (int i = 0; i < line; ++i) {
            result[i] = DataInOutputUtils.readIntArray(input);
        }
        return result;
    }

    public static int[] readIntArray(DataInput input) throws IOException {
        int len = input.readInt();
        byte[] result = new byte[len];
        input.readFully(result);
        int[] ints = MyInts.fromByteArrayToArray(result);
        if (ints.length == 3 && ints[0] == 1123992342 && ints[1] == 832718121 && ints[2] == 957462342) {
            return null;
        }
        return ints;
    }

    public static int[] readIntArray(ByteBuffer buffer) {
        int size = buffer.getInt() / 4;
        int[] ints = new int[size];
        buffer.asIntBuffer().get(ints);
        buffer.position(buffer.position() + size * 4);
        if (ints.length == 3 && ints[0] == 1123992342 && ints[1] == 832718121 && ints[2] == 957462342) {
            return null;
        }
        return ints;
    }

    public static void writeIntArray(int[] array, DataOutput output) throws IOException {
        if (array == null) {
            array = nullMagic;
        }
        byte[] bytes = MyInts.toByteArray(array);
        output.writeInt(bytes.length);
        output.write(bytes);
    }

    public static ArrayList<String> readStringArrayList(DataInput input) throws IOException {
        int size = input.readInt();
        ArrayList<String> result = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            result.add(input.readUTF());
        }
        return result;
    }

    public static void writeStringArrayList(ArrayList<String> list, DataOutput output) throws IOException {
        output.writeInt(list.size());
        for (int i = 0; i < list.size(); ++i) {
            output.writeUTF(list.get(i));
        }
    }

    public static <T> ArrayList<T> readArrayList(DataInput input, Function<DataInput, T> reader) throws IOException {
        int size = input.readInt();
        ArrayList<T> result = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            result.add(reader.apply(input));
        }
        return result;
    }

    public static <T> void writeArrayList(ArrayList<T> list, BiConsumer<T, DataOutput> consumer, DataOutput output) throws IOException {
        output.writeInt(list.size());
        for (T val : list) {
            consumer.accept(val, output);
        }
    }
}

