/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public final class ClassPathUtils {
    private static final Pattern JAR_URL_SEPARATOR = Pattern.compile("!");

    public static Set<Class<?>> scanPackage(ClassLoader classLoader, Package pkg) throws IOException {
        return ClassPathUtils.scanPackage(classLoader, pkg.getName());
    }

    public static Set<Class<?>> scanPackage(ClassLoader classLoader, String pkg) throws IOException {
        String packagePath = pkg.replace('.', '/');
        Enumeration<URL> urls = classLoader.getResources(packagePath);
        HashSet classes = new HashSet();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (url.getProtocol().equals("jar")) {
                ClassPathUtils.scanJar(classLoader, classes, url, packagePath);
                continue;
            }
            if (url.getProtocol().equals("file")) {
                ClassPathUtils.scanDirectory(classLoader, pkg, classes, url, pkg);
                continue;
            }
            throw new IllegalArgumentException("Illegal url : " + url);
        }
        return classes;
    }

    private static void scanDirectory(ClassLoader classLoader, String pkg, Set<Class<?>> classes, URL url, String packageName) throws IOException {
        String packagePath;
        ArrayDeque<File> files = new ArrayDeque<File>();
        try {
            File packageAsFile = new File(url.toURI());
            packagePath = packageAsFile.getPath();
            files.add(packageAsFile);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        while (!files.isEmpty()) {
            File file = (File)files.pop();
            for (File child : file.listFiles()) {
                if (child.getName().endsWith(".class")) {
                    Class<?> cl;
                    String fileName = child.getPath().substring(packagePath.length() + 1).replace(File.separatorChar, '.');
                    String className = pkg + "." + fileName.substring(0, fileName.length() - 6);
                    if (!className.startsWith(packageName) || (cl = ClassPathUtils.safeClassForName(classLoader, className)) == null) continue;
                    classes.add(cl);
                    continue;
                }
                if (!child.isDirectory()) continue;
                files.add(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanJar(ClassLoader classLoader, Set<Class<?>> classes, URL url, String packagePath) throws IOException {
        String[] fileAndPath = JAR_URL_SEPARATOR.split(url.getFile().substring(5));
        JarFile jarFile = new JarFile(fileAndPath[0]);
        try {
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String className;
                Class<?> cl;
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class") || !entry.getName().startsWith(packagePath) || !entry.getName().startsWith(fileAndPath[1].substring(1)) || (cl = ClassPathUtils.safeClassForName(classLoader, className = entry.getName().substring(0, entry.getName().length() - 6).replace('/', '.'))) == null) continue;
                classes.add(cl);
            }
        }
        finally {
            jarFile.close();
        }
    }

    public static Class<?> safeClassForName(ClassLoader classLoader, String className) {
        try {
            if (className.startsWith("com.sun")) {
                return null;
            }
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    private ClassPathUtils() {
    }
}

