/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits;

public interface Strategy<ContextT> {
    public Token tryAcquire(ContextT var1);

    public void setLimit(int var1);

    public static interface Token {
        public boolean isAcquired();

        public int getInFlightCount();

        public void release();

        public static Token newNotAcquired(final int inFlight) {
            return new Token(){

                @Override
                public boolean isAcquired() {
                    return false;
                }

                @Override
                public int getInFlightCount() {
                    return inFlight;
                }

                @Override
                public void release() {
                }
            };
        }

        public static Token newAcquired(final int inFlight, final Runnable release) {
            return new Token(){

                @Override
                public boolean isAcquired() {
                    return true;
                }

                @Override
                public int getInFlightCount() {
                    return inFlight;
                }

                @Override
                public void release() {
                    release.run();
                }
            };
        }
    }
}

