/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.dyno.queues;

import java.util.concurrent.TimeUnit;

public class Message {
    private String id;
    private String payload;
    private long timeout;
    private int priority;
    private String shard;

    public Message() {
    }

    public Message(String id, String payload) {
        this.id = id;
        this.payload = payload;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setTimeout(long time, TimeUnit unit) {
        this.timeout = TimeUnit.MILLISECONDS.convert(time, unit);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setPriority(int priority) {
        if (priority < 0 || priority > 99) {
            throw new IllegalArgumentException("prioirty MUST be between 0 and 99 (inclusive)");
        }
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getShard() {
        return this.shard;
    }

    public void setShard(String shard) {
        this.shard = shard;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "Message [id=" + this.id + ", payload=" + this.payload + ", timeout=" + this.timeout + ", priority=" + this.priority + "]";
    }
}

