/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.workrequests.responses;

import com.oracle.bmc.workrequests.model.WorkRequestSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListWorkRequestsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<WorkRequestSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListWorkRequestsResponse(String opcNextPage, String opcRequestId, List<WorkRequestSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<WorkRequestSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<WorkRequestSummary> items;

        public Builder copy(ListWorkRequestsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<WorkRequestSummary> items) {
            this.items = items;
            return this;
        }

        public ListWorkRequestsResponse build() {
            return new ListWorkRequestsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListWorkRequestsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

