package com.qiho.manager.biz.params;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * Created by danke on 2017/9/14.
 */
@ApiModel("商品与广告计划关联参数")
public class ItemAdvertParam {

    @ApiModelProperty("商品ID")
    @Min(value=1, message="商品ID必须大于0")
    @NotNull
    private Long   itemId;

    @ApiModelProperty("广告计划字符串,逗号隔开")
    private String   advertIds;

    @ApiModelProperty("商品库存阈值")
    @NotNull
    private Long threshold;

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getAdvertIds() {
        return advertIds;
    }

    public void setAdvertIds(String advertIds) {
        this.advertIds = advertIds;
    }

    public Long getThreshold() {
        return threshold;
    }

    public void setThreshold(Long threshold) {
        this.threshold = threshold;
    }
}
