package com.qiho.manager.biz.params.advert;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Size;


/**
 * @author chensong
 * @create 2018-08-21
 */
@ApiModel("默认的商品广告配置")
public class DefaultItemAdvertParam {

    @ApiModelProperty("商品图片")
    @NotBlank(message = "商品图片地址不能为空")
    private String image;

    @ApiModelProperty("弹窗文案")
    @NotBlank(message = "弹窗文案不能为空")
    @Size(min = 1, max = 20, message = "弹窗文案限制在1-20个字符")
    private String text;

    @ApiModelProperty("跳转链接")
    @NotBlank(message = "跳转链接不能为空")
    private String url;

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}
