package com.qiho.manager.biz.params.page;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;

/**
 * @author peanut.huang
 * @date 2018/2/24.
 */
@ApiModel("百奇页面保存参数")
public class PageSaveParam {

    @ApiModelProperty("页面id")
    private Long id;

    @ApiModelProperty("页面名称")
    @NotEmpty
    private String pageName;

    @ApiModelProperty("页面类型")
    @NotNull
    private int pageType;

    @ApiModelProperty("页面效果图")
    @NotNull
    private String pageImg;

    @ApiModelProperty("base64加密后的代码")
    @NotNull
    private String code;

    @ApiModelProperty("口令")
    @NotNull
    private String command;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPageName() {
        return pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public String getPageImg() {
        return pageImg;
    }

    public void setPageImg(String pageImg) {
        this.pageImg = pageImg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getPageType() {
        return pageType;
    }

    public void setPageType(int pageType) {
        this.pageType = pageType;
    }

    public String getCommand() {
        return command;
    }

    public void setCommand(String command) {
        this.command = command;
    }
}
