package com.qiho.manager.biz.runnable;

import java.util.List;

/**
 * @author jiafeng.geng
 * @date 2018-8-29
 * 订单处理策略接口(单例)
 */
public interface AbstractItemEvaluateHandler<T> {

    /**
     * 将文件中的一行String转成Dto对象(即解析策略)
     *
     * @param row    行
     * @param itemId 商品ID
     * @return
     */
    T transform(String row, Long itemId);

    /**
     * 注入任务(执行策略)
     *
     * @param cacheKey
     * @param list
     * @return 提交的有效条数
     */
    Integer exeTask(String cacheKey, List<T> list);

}
