package com.qiho.manager.biz.runnable;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.logistics.LogisticsOrderDto;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.remoteservice.RemoteLogisticsOrderService;
import com.qiho.manager.biz.params.OrdersLogisticsParam;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.util.AppLogUtil;
import com.qiho.manager.common.util.UploadTool;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Created by qianjue on 2017/9/22.
 */
@Component
@Scope("prototype")
public class DistributeOrderExportRunnable extends BaseExportRunnable implements  Runnable{

	@Autowired
	private RemoteLogisticsOrderService remoteLogisticsOrderService;

	private File file;

	private String  filePath  = "logistics/";

	private Long taskId = System.currentTimeMillis();

	private static final int  BATCH_NUM = 100;


	private Logger logger = LoggerFactory.getLogger(DistributeOrderExportRunnable.class);

	@Override
	public void run() {

		int count = remoteLogisticsOrderService.queryDistributeOverTimeNum();
		int batch = getBatchs(count);
		CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_DISTRIBUTE_LOGISTICS_ORDER;
		String key = constantseEnum.getCacheKey(taskId);
		HashOperations<String,String,Object> operations = redisTemplate.opsForHash();
		Workbook workbook = null;
		try(FileOutputStream outputStream = new FileOutputStream(file)){
			List<OrdersLogisticsParam> exportList = Lists.newArrayList();

			for(int i = 0;i < batch; i++ ){
				List<LogisticsOrderDto> result = remoteLogisticsOrderService.queryDistributeOverTimePage(i,BATCH_NUM);
				List<OrdersLogisticsParam> list = transferExcelEntity(result);
				exportList.addAll(list);
				operations.increment(key,"successCount",list.size());
			}
			workbook = ExcelExportUtil.exportBigExcel(new ExportParams(),OrdersLogisticsParam.class,exportList);
			workbook.write(outputStream);
			operations.put(key,"message","文件上传中");
			String url = UploadTool.uploadOssNotCDN(file,
					filePath+file.getName(),"application/x-msdownload;charset=GBK");
			operations.put(key,"url",url);
			operations.put(key,"message","导出成功");
		} catch (Exception e) {
			AppLogUtil.error(logger,"DistributeOrderExportRunnable run error",e);
			operations.put(key, "message", e.getMessage());
		} finally {
			operations.put(key, "success", "true");
			ExcelExportUtil.closeExportBigExcel();
			try {
				workbook.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
			if (file != null && file.exists() && !file.delete()) {
				AppLogUtil.warn(logger,"file delete error or file not exists");
			}
		}

	}

	private int getBatchs(int count) {
		return count %  BATCH_NUM == 0 ? count / BATCH_NUM : count / BATCH_NUM + 1;
	}

	public Map<String,Object> init() {
		file = super.getFile2(filePath);
		return super.init(file,taskId, CacheConstantseEnum.EXPORT_DISTRIBUTE_LOGISTICS_ORDER);
	}

	/**
	 * 转换成Excel导出的格式
	 * @param result
	 * @return
	 */
	private List<OrdersLogisticsParam> transferExcelEntity(List<LogisticsOrderDto> result){

		List<OrdersLogisticsParam> list = Lists.newArrayList();
		for (LogisticsOrderDto dto : result) {
			OrdersLogisticsParam ordersExport = BeanUtils.copy(dto, OrdersLogisticsParam.class);
			ordersExport.setLogisticsStatus(LogisticsOrderStatusEnum.getByCode(dto.getOrderStatus()).getDesc());
			list.add(ordersExport);
		}

		return list;
	}

}
