package com.qiho.manager.biz.runnable;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.qiho.center.api.dto.monitor.LogisticsMonitorReportDto;
import com.qiho.center.api.enums.LogisticsOrderStatusEnum;
import com.qiho.center.api.enums.OrderStatusEnum;
import com.qiho.center.api.params.MonitorReportQueryParam;
import com.qiho.center.api.remoteservice.monitor.RemoteMonitorReportService;
import com.qiho.manager.biz.service.logistics.LogisticsService;
import com.qiho.manager.common.constant.CacheConstantseEnum;
import com.qiho.manager.common.util.AppLogUtil;
import com.qiho.manager.common.util.UploadTool;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created by qianjue on 2017/11/2.
 */
@Component
@Scope("prototype")
@Deprecated
public class MonitorReportExportRunnable extends BaseExportRunnable implements  Runnable{

	private File file;

	private String  filePath  = "monitor/report/";

	private Long taskId = new Date().getTime();

	private String[] headersColumn = {"物流公司","监控点","涉及订单总数","正常订单数","黄牌订单数","红牌订单数"};

	private Logger logger = LoggerFactory.getLogger(MonitorReportExportRunnable.class);

	private MonitorReportQueryParam queryParam;

	@Resource
	private RemoteMonitorReportService  remoteMonitorReportService;
	@Resource
	private LogisticsService logisticsService;


	public Map<String,Object> init(){
		file = super.getFile(filePath);
		return super.init(file,taskId,CacheConstantseEnum.EXPORT_MONITOR_REPORT);
	}

	@Override
	public void run() {
		CharSink charSink = Files.asCharSink(file, Charset.forName("GBK"), FileWriteMode.APPEND);
		CacheConstantseEnum constantseEnum = CacheConstantseEnum.EXPORT_MONITOR_REPORT;
		String key = constantseEnum.getCacheKey(taskId);
		HashOperations<String,String,Object> operations = redisTemplate.opsForHash();
		try{
			//封装csv文件的head信息
			List<String> headers = Lists.newArrayList(joiner.join(headersColumn));
			charSink.writeLines(headers);
			//循环分批次查询数据写入csv文件
			MonitorReportToString transform = new MonitorReportToString();
			List<LogisticsMonitorReportDto> result = remoteMonitorReportService.queryList(queryParam);
			List<String> list = Lists.transform(result,transform);
			charSink.writeLines(list);
			operations.increment(key,"successCount",list.size());
			operations.put(key,"message","文件上传中");
			String url = UploadTool.uploadOssNotCDN(file,filePath+file.getName(),"application/csv;charset=GBK");
			operations.put(key,"url",url);
			operations.put(key,"message","导出成功");
		} catch (Exception e) {
			AppLogUtil.error(logger,"MonitorReportExportRunnable run error",e);
			operations.put(key, "message", e.getMessage());
		} finally {
			operations.put(key, "success", "true");
			if (file != null && file.exists() && !file.delete()) {
				AppLogUtil.warn(logger,"file delete error or file not exists");
			}
		}
	}


	private class MonitorReportToString implements Function<LogisticsMonitorReportDto, String> {

		@Override
		public String apply(LogisticsMonitorReportDto input) {
			List<String> row = Lists.newArrayList();
			row.add(useForNull(logisticsService.getBaiqiLogisticsCodeToName().get(input.getLogisticsCode())));
			row.add(useForNull(StringUtils.equals(input.getMonitorStatus(), OrderStatusEnum.TO_SEND.getCode()) ?
				OrderStatusEnum.TO_SEND.getDesc() : LogisticsOrderStatusEnum.getByCode(input.getMonitorStatus()).getDesc()));
			row.add(useForNull(input.getOrderCountTotal()));
			row.add(useForNull(input.getOrderCountNormal()));
			row.add(useForNull(input.getOrderCountYellow()));
			row.add(useForNull(input.getOrderCountRed()));
			return joiner.join(row);
		}
	}

	public MonitorReportQueryParam getQueryParam() {
		return queryParam;
	}

	public void setQueryParam(MonitorReportQueryParam queryParam) {
		this.queryParam = queryParam;
	}
}
