package com.qiho.manager.biz.runnable.ordertaskhandler;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.NumberUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.qiho.center.api.enums.ExpressCompanyEnum;
import com.qiho.center.api.params.ExpressBlackListOperationParams;
import com.qiho.center.api.remoteservice.RemoteExpressBlackListService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by danke on 2017/7/19.
 */
@Service
public class ExpressBlackListHandler implements AbstractOrderHandler<ExpressBlackListOperationParams> {

    private Splitter splitter = Splitter.on(",").trimResults().omitEmptyStrings().limit(4);

    @Autowired
    private RemoteExpressBlackListService remoteExpressBlackListService;

    @Override
    public ExpressBlackListOperationParams transform(String row, String status) {
        ExpressBlackListOperationParams params = new ExpressBlackListOperationParams();
        List<String> list = splitter.splitToList(row);
        if (CollectionUtils.isEmpty(list) || StringUtils.isBlank(list.get(0))) {
            return null;
        }
        //第一个字段为行政区域代码
        params.setBkValue(list.get(0));
        //第二列为类型，圆通COD,圆通速递
        if (list.size() > 1) {
        	params.setCompanyEnum(ExpressCompanyEnum.getByName(list.get(1)));
        }
        if (list.size() > 2 && NumberUtils.isNumeric(list.get(2))){
            params.setDataType(Integer.valueOf(list.get(2)));
        }
        return params;
    }

    @Override
    public ExpressBlackListOperationParams transform(String row) {
        return transform(row,null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<ExpressBlackListOperationParams> list) {
        return exeTask(cacheKey,list,null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<ExpressBlackListOperationParams> list, JSONObject extraParams) {
    	List<ExpressBlackListOperationParams> relist = Lists.newArrayList();
        for (ExpressBlackListOperationParams params : list){
            if (null==params.getCompanyEnum() || StringUtils.isBlank(params.getBkValue()) || null == params.getDataType()){
               continue;
            }
            relist.add(params);
        }
        DubboResult<Integer> result = remoteExpressBlackListService.batchAddExpressBlackList(cacheKey, relist);
        if (result.isSuccess()){
        	 return result.getResult();	
        }
        return 0;
    }
}
