package com.qiho.manager.biz.runnable.ordertaskhandler;

import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.qiho.center.api.params.WdtOrderAuditParams;
import com.qiho.center.api.remoteservice.order.RemoteErpOrderService;
import com.qiho.manager.biz.runnable.AbstractOrderHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by weny.cai on 2017/11/18.
 * 旺店通 订单审核策略
 */
@Service
public class WdtOrderAuditHandler implements AbstractOrderHandler<WdtOrderAuditParams> {

    @Autowired
    private RemoteErpOrderService remoteErpOrderService;

    private Logger logger = LoggerFactory.getLogger(WdtOrderAuditHandler.class);

    private Splitter splitter = Splitter.on(",").trimResults().limit(3);


    @Override
    public WdtOrderAuditParams transform(String row, String status) {
        WdtOrderAuditParams params = new WdtOrderAuditParams();
        try {
            List<String> line = splitter.splitToList(row);
            if(line.size()<3){
                return new WdtOrderAuditParams();
            }
            params.setErpId(line.get(0));
            params.setLogisticsName(line.get(1));
            params.setPostId(line.get(2));
            return params;
        }catch (Exception e){
            logger.info("旺店通订单行解析失败={}",e,row);
            return null;
        }
    }

    @Override
    public WdtOrderAuditParams transform(String row) {
        return transform(row,null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<WdtOrderAuditParams> list) {
        return exeTask(cacheKey,list,null);
    }

    @Override
    public Integer exeTask(String cacheKey, List<WdtOrderAuditParams> list, JSONObject extraParams) {
        DubboResult<Integer> result = remoteErpOrderService.wdtBatchAuditOrder(cacheKey,list);
        return result.getResult();
    }
}
