package com.qiho.manager.biz.service;

import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.params.BlackListParams;
import com.qiho.center.api.params.blacklist.BaiqiBlackListQueryParam;
import com.qiho.manager.biz.params.BatchAuditOrderParam;
import com.qiho.manager.biz.vo.OrderDealWithVO;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.blackList.BlackListVO;


/**
 * 
 * ClassName: LogisticsOrderService <br/>
 * Function: 黑名单查询Service. <br/>
 * date: 2017年6月3日 下午2:39:13 <br/>
 *
 * @author chencheng
 * @version
 */
public interface BlackListService {

    /**
     * 分页查询黑名单数据
     *
     * @param params
     * @return
     */
    Pagenation<BlackListVO> queryBlackListPage(BaiqiBlackListQueryParam params);

    /**
     * 批量黑名单处理
     *
     * @author chencheng
     * @param param
     * @param extraParams 
     * @return
     */
    OrderDealWithVO batchAddBlackList(BatchAuditOrderParam param, JSONObject extraParams);
    
    /**
     * 黑名单导出
     * @param params
     * @return
     */
    Map<String, Object> submitBlackListExport(BaiqiBlackListQueryParam params);

    /**
     * 删除黑名单
     * @param id
     * @return
     */
    Boolean deleteBlackList(Long id);

    /**
     * 批量物流黑名单处理
     */
    OrderDealWithVO batchExpressBlackList(BatchAuditOrderParam param);

}
