/**
 * Project Name:qiho-manager-biz
 * File Name:ItemService.java
 * Package Name:com.qiho.manager.biz.service
 * Date:2017年5月22日下午7:24:38
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package com.qiho.manager.biz.service;

import java.util.List;
import java.util.Map;

import com.qiho.center.api.dto.ItemAdvertDto;
import com.qiho.center.api.dto.ItemDetailDto;
import com.qiho.center.api.dto.ItemDto;
import com.qiho.manager.biz.params.ItemAdvertParam;
import com.qiho.manager.biz.vo.ItemAdvertVo;
import com.qiho.manager.biz.vo.ItemDetailVO;
import com.qiho.manager.biz.vo.ItemVO;
import com.qiho.manager.biz.vo.Pagenation;

/**
 * ClassName:ItemService <br/>
 * Date:     2017年5月22日 下午7:24:38 <br/>
 * @author   zhanglihui
 * @version
 * @since    JDK 1.6
 * @see
 */
public interface ItemService {

    /**
     * 分页查询商品信息
     * @author zhanglihui
     * @param queryItem
     * @param pageNum
     * @param pageSize
     * @return Pagenation<ItemVO>
     */
    Pagenation<ItemVO> queryList(ItemDto queryItem, Integer pageNum, Integer pageSize);

    /**
     * 查询商品详情
     * @author zhanglihui
     * @param itemId
     * @return ItemDetailVO
     */
    ItemDetailVO queryItemDetail(Long itemId);

    /**
     * 保存商品详情
     * @author zhanglihui
     * @param itemDetailDto
     * @return itemId
     */
    Long saveItem(ItemDetailDto itemDetailDto);

    /**
     * 批量修改商品状态
     * @author zhanglihui
     * @param itemIdList
     * @param status
     */
    void updateStatusBatch(List<Long> itemIdList, String status, Long gmtModifier);

    /**
     * 批量删除商品
     * @author zhanglihui
     * @param itemIdList
     */
    void deleteBatch(List<Long> itemIdList, Long gmtModifier);

    /**
     * 批量推荐商品
     * @author zhanglihui
     * @param itemIdList
     */
    void recommendBatch(List<Long> itemIdList);

    /**
     * 将ItemDto转化成VO
     * @param itemDtos
     * @return List<ItemVO>
     */
    List<ItemVO> transformItemVO(List<ItemDto> itemDtos);


    List<ItemVO> querySimpleList(ItemDto itemDto);

    /**
     * 更新商品对应的广告计划id及关闭广告计划阈值
     */
    Boolean updateItemAdvertIdsAndthreshold(ItemAdvertParam param);

    /**
     * 查询对应商品广告计划ids和阈值
     */
    ItemAdvertVo queryItemAdvertByItemId(Long itemId);

    /**
     * 根据itemId查询商品扩展信息
     */
    ItemAdvertDto queryExtParamByItemId(Long itemId);

    /**
     * 更新商品扩展字段,参数extparam需要提前处理
     */
    Boolean updateExtParamByItemId(Long itemId,Map<String,String> extParam);

    /**
     * 根据商品id集合批量查询商品信息
     */
    List<ItemVO> queryItemsByItemIds(List<Long> itemIdList);
}

