package com.qiho.manager.biz.service.advert;

import com.qiho.manager.biz.params.advert.CollectionAdvertSaveParam;
import com.qiho.manager.biz.vo.advert.CollectionAdvertVO;

import java.util.List;

/**
 * 集合页广告位模块服务接口
 *
 * @author chensong
 * @create 2018-09-13
 */
public interface CollectionAdvertService {

    /**
     * 保存集合页广告位
     * @param param
     * @return
     */
    Boolean saveCollectionAdvert(CollectionAdvertSaveParam param);

    /**
     * 获取所有的集合页广告位数据
     * @return
     */
    List<CollectionAdvertVO> listAllCollectionAdvert();

    /**
     * 删除集合页广告位数据
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 根据id查询集合页广告位数据
     * @param id
     * @return
     */
    CollectionAdvertVO findById(Long id);


}
