package com.qiho.manager.biz.service.blacklist;

import com.qiho.center.api.dto.bklist.BlackListStrategyDto;
import com.qiho.manager.biz.vo.blackList.BlackListStrategyVO;

import java.util.List;

/** 黑名单策略相关服务接口
 * @author chensong
 * @create 2018-04-25 17:23
 **/
public interface BlackListStrategyService {


    /**
     * 获取黑名单策略详情
     * @param id
     * @return
     */
    BlackListStrategyVO findById(Long id);

    /**
     * 查询黑名单策略
     * @param merchantId
     * @return
     */
    List<BlackListStrategyVO> queryBlackListStrategy(Long merchantId);

    /**
     * 删除黑名单策略
     * @param id
     * @return
     */
    Boolean deleteBlackListStrategy(Long id);

    /**
     * 新增或保存黑名单策略
     * @param param
     * @return
     */
    Boolean saveBlackListStrategy(BlackListStrategyDto param);

}
