package com.qiho.manager.biz.service.finance;


import com.qiho.center.api.params.finance.BaiqiMerchantFreetextParam;
import com.qiho.center.api.params.finance.FinanceBasePageParam;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.account.IdAndNameVO;
import com.qiho.manager.biz.vo.merchant.FinanceBaseInfoVo;
import com.qiho.manager.biz.vo.merchant.FinanceDetailVo;
import com.qiho.manager.biz.vo.merchant.HistoricalBalanceVo;

import java.util.List;

/**
 * Created by xianhongwei on 2017/12/21.
 */
public interface FinanceService {

    /**
     * 查找所有财务基础信息
     * @return
     */
    Pagenation<FinanceBaseInfoVo> findAllFinanceBaseInfo(FinanceBasePageParam pageParam);



    /**
     * 根据商家名称模糊查询
     */
    Pagenation<FinanceDetailVo> findDetailByPara(BaiqiMerchantFreetextParam param);

    /**
     * 查询所有商户简单信息
     * @param type 商户类型 0 商家  2：@
     * @return
     */
    List<IdAndNameVO> querySimpleInfo(Integer type);

    /**
     * 根据筛选条件查询
     */
    Pagenation<HistoricalBalanceVo> findHistoricalBalanceByPara(BaiqiMerchantFreetextParam param);

}
