/**
 * Project Name:qiho-manager-biz File Name:CategoryServiceImpl.java Package Name:com.qiho.manager.biz.service.impl
 * Date:2017年5月16日下午9:11:48 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.manager.biz.service.impl;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;

import com.qiho.center.api.dto.CategoryDto;
import com.qiho.center.api.remoteservice.RemoteCategoryService;
import com.qiho.manager.biz.service.CategoryService;
import com.qiho.manager.biz.vo.CategoryVO;

/**
 * ClassName:CategoryServiceImpl <br/>
 * 类目管理实现类 <br/>
 * Date: 2017年5月16日 下午9:11:48 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class CategoryServiceImpl implements CategoryService {

    @Autowired
    private RemoteCategoryService remoteCategoryService;

    @Override
    public List<CategoryVO> getCategoryByPid(long pid) {
        DubboResult<List<CategoryDto>> result = remoteCategoryService.getCategoryByPid(pid);
        return BeanUtils.copyList(result.getResult(), CategoryVO.class);
    }

    @Override
    public void deleteCategoryById(Long categoryId) {
        remoteCategoryService.deleteCategoryById(categoryId);
    }

    @Override
    public void updateCategoryById(Long categoryId, String categoryName) {
        remoteCategoryService.updateCategoryById(categoryId, categoryName);
    }

    @Override
    public void saveCategory(Long pid, List<String> categoryList) {
        if (CollectionUtils.isEmpty(categoryList)) {
            return;
        }
        remoteCategoryService.saveCategory(pid, categoryList);
    }

    @Override
    public void sortByPayLoad(Long sortId, Integer startPayload, Integer endPayload) {
        remoteCategoryService.sortByRange(sortId, startPayload, endPayload);
    }

}
