/**
 * Project Name:qiho-manager-biz File Name:FundOrderServiceImpl.java Package Name:com.qiho.manager.biz.service.impl
 * Date:2017年6月9日下午5:34:12 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.manager.biz.service.impl;

import java.util.List;

import com.qiho.center.api.enums.FundBizTypeEnum;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;

import com.google.common.collect.Lists;
import com.qiho.center.api.dto.FundOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.enums.FundStatusEnum;
import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.params.FundPageParam;
import com.qiho.center.api.remoteservice.order.RemoteFundOrderService;
import com.qiho.manager.biz.service.FundOrderService;
import com.qiho.manager.biz.vo.FundOrderVO;
import com.qiho.manager.biz.vo.Pagenation;

/**
 * ClassName:FundOrderServiceImpl <br/>
 * Date: 2017年6月9日 下午5:34:12 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
@Service
public class FundOrderServiceImpl implements FundOrderService {

    @Autowired
    private RemoteFundOrderService remoteFundOrderService;

    @Override
    public Pagenation<FundOrderVO> queryList(FundPageParam param) {
        DubboResult<PagenationDto<FundOrderDto>> result = remoteFundOrderService.queryFundPage(param);
        Pagenation<FundOrderVO> page = new Pagenation<>();
        page.setTotal(result.getResult().getTotal());
        List<FundOrderDto> list = result.getResult().getList();
        List<FundOrderVO> fundList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(list)) {
            for(FundOrderDto fundDto : list){
                FundOrderVO vo = new FundOrderVO();
                vo.setAmt(fundDto.getAmt());
                vo.setFundId(fundDto.getFundId());
                vo.setFundStatus(FundStatusEnum.getEnumByCode(fundDto.getFundStatus()).getDesc());
                vo.setGmtCreate(DateUtils.getSecondStr(fundDto.getGmtCreate()));
                vo.setGmtModified(DateUtils.getSecondStr(fundDto.getGmtModified()));
                vo.setOrderId(fundDto.getOrderId());
                vo.setOutSeqNo(fundDto.getOutSeqNo());
                vo.setPayType(PayTypeEnum.getEnumByCode(fundDto.getPayType()).getDesc());
                vo.setBizType(FundBizTypeEnum.getByCode(fundDto.getBizType()).getDesc());
                fundList.add(vo);
            }
        }
        page.setList(fundList);
        return page;
    }

}
