package com.qiho.manager.biz.service.impl;

import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.advert.ItemAdvertPlanDto;
import com.qiho.center.api.dto.advert.ItemCostDto;
import com.qiho.center.api.dto.advert.TuiaPlanDto;
import com.qiho.center.api.params.advert.ItemBindPlanParams;
import com.qiho.center.api.params.advert.ItemPlanQueryParams;
import com.qiho.center.api.params.data.ItemDataQueryParam;
import com.qiho.center.api.remoteservice.advert.RemoteItemPlanService;
import com.qiho.center.api.remoteservice.data.RemoteGoodsDataService;
import com.qiho.manager.biz.service.ItemPlanService;
import com.qiho.manager.biz.vo.Pagenation;
import com.qiho.manager.biz.vo.advert.ItemCostVO;
import com.qiho.manager.biz.vo.advert.ItemPlanVO;
import com.qiho.manager.biz.vo.advert.TuiaPlanVO;
import com.qiho.manager.common.exception.QihoManagerException;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import static java.math.BigDecimal.ROUND_UNNECESSARY;

/**
 * @author chensong
 * @create 2018-01-10 09:42
 **/
@Service
public class ItemPlanServiceImpl implements ItemPlanService {


     @Autowired
     private RemoteItemPlanService remoteItemPlanService;
     @Autowired
     private RemoteGoodsDataService remoteGoodsDataService;


    @Override
    public Pagenation<ItemPlanVO> queryList(Long itemId, String itemName, Integer pageNum, Integer pageSize) {
        Pagenation<ItemPlanVO> page = new Pagenation<>();
        ItemPlanQueryParams params = new ItemPlanQueryParams();
        params.setItemId(itemId);
        params.setItemName(itemName);
        params.setPageNum(pageNum);
        params.setPageSize(pageSize);
        PagenationDto<ItemAdvertPlanDto> result = remoteItemPlanService.queryPage(params);

        Integer total = result.getTotal();
        page.setTotal(total);
        if (total.intValue() == 0) {
        page.setList(Lists.newArrayList());
        return page;
        }

        // 类型转换
        List<ItemAdvertPlanDto> itemPlanList = result.getList();
        List<ItemPlanVO> list = Lists.transform(itemPlanList, itemPlan -> {
        ItemPlanVO vo = BeanUtils.copy(itemPlan, ItemPlanVO.class);
        vo.setPlanList(BeanUtils.copyList(itemPlan.getAdvertList(), TuiaPlanVO.class));
        return vo;
        });
        page.setList(list);

        return page;
    }

    @Override
    public List<TuiaPlanVO> findPlan(Long itemId) {
        List<TuiaPlanDto> dtoList = remoteItemPlanService.getUnbindPlan(itemId);
         return BeanUtils.copyList(dtoList, TuiaPlanVO.class);
    }

    @Override
    public Boolean bindPlan(Long itemId, List<Long> planList) {
        if (CollectionUtils.isEmpty(planList)) {
            throw new QihoManagerException("传入的广告计划列表为空");
        }

        ItemBindPlanParams planParams = new ItemBindPlanParams();
        planParams.setCreater(RequestTool.getAdminId());
        planParams.setModifier(RequestTool.getAdminId());
        planParams.setItemId(itemId);
        planParams.setPlanList(planList);
        Boolean result = false;
        try {
            result = remoteItemPlanService.bingPlan(planParams);
        } catch (Exception e) {
            throw new QihoManagerException(e.getMessage());
        }
        return result;
    }

    @Override
    public Pagenation<ItemCostVO> queryData(Long itemid, String itemName, Date startTime, Date endTime, Integer pageNum, Integer pageSize) {
        Pagenation<ItemCostVO> page = new Pagenation<>();
        ItemDataQueryParam param = new ItemDataQueryParam();
        param.setItemId(itemid);
        param.setItemName(itemName);
        param.setStartTime(startTime);
        param.setEndTime(endTime);
        param.setOffset((pageNum - 1 ) * pageSize);
        param.setMax(pageSize);
        PagenationDto<ItemCostDto> result = remoteGoodsDataService.queryPage(param);

        Integer total = result.getTotal();
        page.setTotal(total);
        if (total.intValue() == 0) {
            page.setList(Lists.newArrayList());
            return page;
        }

        List<ItemCostVO> list = Lists.transform(result.getList(), dto -> {
            ItemCostVO vo = new ItemCostVO();
            vo.setItemId(dto.getItemId());
            vo.setItemName(dto.getItemName());
            vo.setClick(String.valueOf(dto.getClick()));
            vo.setCost(fenToYuan(dto.getCost()));
            vo.setExpose(String.valueOf(dto.getExpose()));
            return vo;
        });
        page.setList(list);
        return page;

    }


    public static String fenToYuan(Long amount){
        if(amount == null){
            return "0.00";
        }
        return new BigDecimal(amount).divide(new BigDecimal(100),2,ROUND_UNNECESSARY).toString();
    }

}
